% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orloca-package.R
\name{paquete-orloca}
\alias{paquete-orloca}
\title{Modelos de Investigacion Operativa para el Analisis de Localizacion (Operations Research LOCational Analysis Models)}
\description{
Objetos y metodos para manejar y resolver el problema de localizacion de suma ponderada minima, tambien conocido como problema de Fermat-Weber.

\preformatted{

Paquete:   orloca

Version:   5.5

Fecha:      2023-09-19

Licencia:   GPL (>= 3)
}
}
\details{
El problema de localizacion de suma minima busca un punto tal que la suma ponderada de las distancias a los puntos de demanda se minimice.
Vease "The Fermat-Weber location problem revisited" por Brimberg, Mathematical Programming, 1, pag. 71-76, 1995. \doi{10.1007/BF01592245}.

Se usan algoritmos generales de optimizacion global para resolver el problema, junto con el metodo adhoc Weiszfeld, vease "Sur le point pour lequel la Somme des distance de n points donnes est minimum", por Weiszfeld, Tohoku Mathematical Journal, First Series, 43, pag. 355-386, 1937 o "On the point for which the sum of the distances to n given points is minimum", por E. Weiszfeld y F. Plastria, Annals of Operations Research, 167, pg. 7-41, 2009. \doi{10.1007/s10479-008-0352-z}.

El paquete proporciona una clase \code{loca.p} que representa un problema de localizacion sobre el plano.
Tambien permite dibujar los puntos junto a la funcion objetivo.
Dicho objetivo es la suma ponderada de las distancias que viajan los clientes del servicio.

Versiones no planas del problema podrian incorporarse en futuras versiones del paquete.

Para una demostracion, cargue el paquete con la instrucción \code{library(orloca)} y ejecute la demostracion con la instruccion \code{demo(orloca)}.

El paquete esta preparado para su internacionalizacion.
Las traducciones de los ficheros .mo recibidas seran anadidas en proximas versiones del paquete.
}
\examples{
# Un objeto loca.p no ponderado
o <- loca.p(x = c(-1, 1, 1, -1), y = c(-1, -1, 1, 1))

# Calcula la funcion objetivo en el punto (3, 4)
# [1] 20.39384
zsum(o, 3, 4)

# Calcula la suma de las distancias al punto (3, 4) usando la norma lp con p = 2.5
# [1] 19.27258
zsum(o, 3, 4, lp = 2.5)

# Resuelve el problema de localizacion
# [1] 0 0
zsummin(o)

# Curvas de nivel
contour(o)

# Ejecuta una demo del paquete
demo(orloca)
}
\references{
[1] Brimberg, J. \emph{The Fermat-Weber location problem revisited}, Mathematical Programming, 1, pg. 71-76, 1995. \doi{10.1007/BF01592245}.

[2] Love, R. F., Morris, J. G., Wesolowsky, G. O. \emph{Facilities Location: Chapter 2: Introduction to Single-Facility Location}, 1988, North-Holland

[3] Weiszfeld, E. and Plastria, F. \emph{On the point for which the sum of the distances to n given points is minimum}, Annals of Operations Research, 167, pg. 7-41, 2009, \doi{10.1007/s10479-008-0352-z}.

[4] \url{http://knuth.uca.es/orloca/}
}
\author{
Manuel Munoz-Marquez <manuel.munoz@uca.es>

Mantenedor: Manuel Munoz-Marquez <manuel.munoz@uca.es>
}
