% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/header.R
\name{matchHeader}
\alias{matchHeader}
\title{Match String to DICOM Header Field}
\usage{
matchHeader(hdr, string)
}
\arguments{
\item{hdr}{is the result from extracting information from a DICOM header
field; e.g., using \code{extractHeader}.}

\item{string}{is a character string to be matched with the DICOM header.}
}
\value{
A logical vector of length \code{length(hdr)}.
}
\description{
A convenient wrapper function that utilizes internal functions to match
character strings with the DICOM header information.
}
\examples{

x <- readDICOMFile(system.file("dcm/Abdo.dcm", package="oro.dicom"))
modality <- extractHeader(x$hdr, "Modality", numeric=FALSE)
matchHeader(modality, "mr") # case insensitive by default

}
\references{
Digital Imaging and Communications in Medicine (DICOM)\cr
\url{http://medical.nema.org}
}
\seealso{
\code{\link{extractHeader}}
}
\author{
Brandon Whitcher \email{bwhitcher@gmail.com}
}
