% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{gauge_record}
\alias{gauge_record}
\title{Record a value of an OpenTelemetry gauge}
\usage{
gauge_record(name, value, attributes = NULL, context = NULL, meter = NULL)
}
\arguments{
\item{name}{Name of the gauge}

\item{value}{Value to record.}

\item{attributes}{Additional attributes to add.}

\item{context}{Span context. If missing the active context is used,
if any.}

\item{meter}{Meter object (\link{otel_meter}). Otherwise it is passed to
\code{\link[=get_meter]{get_meter()}} to get a meter.}
}
\value{
The gauge object (\link{otel_gauge}), invisibly.
}
\description{
Record a value of an OpenTelemetry gauge
}
\examples{
otel::gauge_record("temperature", 27)
}
\seealso{
Other OpenTelemetry metrics instruments: 
\code{\link{counter_add}()},
\code{\link{histogram_record}()},
\code{\link{up_down_counter_add}()}

Other OpenTelemetry metrics API: 
\code{\link{counter_add}()},
\code{\link{histogram_record}()},
\code{\link{is_measuring_enabled}()},
\code{\link{up_down_counter_add}()}
}
\concept{OpenTelemetry metrics API}
\concept{OpenTelemetry metrics instruments}
