% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{is_measuring_enabled}
\alias{is_measuring_enabled}
\title{Check whether OpenTelemetry metrics collection is active}
\usage{
is_measuring_enabled(meter = NULL)
}
\arguments{
\item{meter}{Meter object (\link{otel_meter}), or a meter name, the
instrumentation scope, to pass to \code{\link[=get_meter]{get_meter()}}.}
}
\value{
\code{TRUE} is OpenTelemetry metrics collection  is active,
\code{FALSE} otherwise.
}
\description{
This is useful for avoiding computation when metrics collection is inactive.
}
\details{
It calls \code{\link[=get_meter]{get_meter()}} with \code{name} and then it calls the meter's
\verb{$is_enabled()} method.
}
\examples{
fun <- function() {
  if (otel::is_measuring_enabled()) {
    xattr <- calculate_some_extra_attributes()
    otel::counter_add("sessions", 1, attributes = xattr)
  }
  # ...
}
}
\seealso{
Other OpenTelemetry metrics API: 
\code{\link{counter_add}()},
\code{\link{gauge_record}()},
\code{\link{histogram_record}()},
\code{\link{up_down_counter_add}()}
}
\concept{OpenTelemetry metrics API}
