% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ordinal_cohens_kappa.R
\encoding{UTF-8}
\name{plot_ordinal_cohens_kappa}
\alias{plot_ordinal_cohens_kappa}
\title{Constructs a serial dependence plot based on the ordinal Cohen's kappa
considering the block distance}
\usage{
plot_ordinal_cohens_kappa(
  series,
  states,
  max_lag = 10,
  alpha = 0.05,
  plot = TRUE,
  title = "Serial dependence plot",
  bar_width = 0.12,
  ...
)
}
\arguments{
\item{series}{An OTS.}

\item{states}{A numerical vector containing the corresponding
states.}

\item{max_lag}{The maximum lag represented in the plot (default is 10).}

\item{alpha}{The significance level for the corresponding hypothesis test (default is 0.05).}

\item{plot}{Logical. If \code{plot = TRUE} (default), returns the serial dependence
plot. Otherwise, returns a list with the values of the ordinal Cohens's kappa, the critical
value and the corresponding p-values.}

\item{title}{The title of the graph.}

\item{bar_width}{The width of the corresponding bars.}

\item{...}{Additional parameters for the function.}
}
\value{
If \code{plot = TRUE} (default), returns the serial dependence plot based on the ordinal Cohens's kappa. Otherwise, the function
returns a list with the values of the ordinal Cohens's kappa, the critical
value and the corresponding p-values.
}
\description{
\code{plot_ordinal_cohens_kappa} constructs a serial dependence plot of an ordinal
time series based on the ordinal Cohen's kappa considering the block distance
}
\details{
Constructs a serial dependence plot based on the ordinal Cohens's kappa, \eqn{\widehat{\kappa}_d(l)},
for several lags, where \eqn{d} is the block distance between ordinal states, that is, \eqn{d(s_i, s_j)=|i-j|} for two states \eqn{s_i} and \eqn{s_j}.
A dashed lined is incorporated indicating the critical value
of the test based on the following asymptotic approximation (under the i.i.d. assumption):
\deqn{\sqrt{\frac{T\widehat{disp}_d^2}{4\sum_{k,l=0}^{n-1}(\widehat{f}_{min\{k,l\}}-\widehat{f}_k\widehat{f}_l)^2}}\bigg(\widehat{\kappa}_d(l)+\frac{1}{T}\bigg)\sim N\big(0, 1\big),} where \eqn{T} is the series length,
\eqn{\widehat{f_k}} is the estimated cumulative probability for state \eqn{s_k}
and \eqn{\widehat{disp}_d} is the DIVC estimate of the dispersion.
}
\examples{
plot_ock <- plot_ordinal_cohens_kappa(series = AustrianWages$data[[100]],
states = 0 : 5, max_lag = 3) # Representing
# the serial dependence plot
list_ck <- plot_ordinal_cohens_kappa(series = AustrianWages$data[[100]],
states = 0 : 5, max_lag = 3, plot = FALSE) # Obtaining
# the values of the ordinal Cohens's kappa, the critical value and the p-values
}
\references{
{

  \insertRef{weiss2019distance}{otsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
