% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_gross.R
\name{find_gross}
\alias{find_gross}
\title{Find gross outliers.}
\usage{
find_gross(
  x,
  max_out,
  multiplier = 3,
  k_neighbours = floor(nrow(x)/100),
  manual_threshold = NULL,
  scale = TRUE
)
}
\arguments{
\item{x}{Data.}

\item{max_out}{Maximum number of outliers.}

\item{multiplier}{Multiplicative factor used to get gross outlier threshold.}

\item{k_neighbours}{Number of neighbours for dbscan::kNNdist.}

\item{manual_threshold}{Optional preset threshold.}

\item{scale}{Logical value controlling whether we apply \code{scale} to \code{x}.}
}
\value{
\code{find_gross} returns a list with the following elements:
\describe{
\item{\code{gross_choice}}{A numeric value indicating the elbow's location.}
\item{\code{gross_bool}}{A logical vector identifying the gross outliers.}
\item{\code{gross_curve}}{ggplot of the highest \code{2 * max_out} kNN distances in
decreasing order.}
\item{\code{gross_scatter}}{ggplot of all kNN distances in index order.}
}
}
\description{
The distance of each observation to its \eqn{k^{th}}{k^th} nearest neighbour
is computed. We assume that the largest \code{max_out} kNN distances correspond to
potential outliers. We select the next largest kNN distance, outside of the
top \code{max_out}, as a benchmark value. We multiply this benchmark kNN distance
by \code{multiplier} to get the minimum threshold for our gross outliers. In other
words, a gross outlier must have a kNN distance at least \code{multiplier} times
greater than all of the observations which we do not consider to be potential
outliers.
}
