% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaflet.R
\name{add_weather}
\alias{add_weather}
\title{Add weather data to leaflet map.}
\usage{
add_weather(map, data, lng = NULL, lat = NULL, icon = NULL,
  template = NULL, popup = NULL, ...)
}
\arguments{
\item{map}{\code{\link[leaflet]{leaflet}} map object}

\item{data}{owm data}

\item{lng}{numeric vector of longitudes
(if \code{NULL} it will be taken from \code{data})}

\item{lat}{numeric vector of latitudes
(if \code{NULL} it will be taken from \code{data})}

\item{icon}{vector of owm icon names
(usually included in weather column of owm data)}

\item{template}{template in the form of \cr
\code{"<b>{{name}}</b>"} \cr
where variable names in brackets correspond to
column names of \code{data} (see also \code{\link{render}})}

\item{popup}{vector containing (HTML) content for popups,
skipped in case parameter \code{template} is given}

\item{...}{see \code{\link[leaflet]{addMarkers}}}
}
\value{
updated map object
}
\description{
Add weather data to leaflet map.
}
\examples{
\dontrun{
   owm_data <- find_city("Malaga", units = "metric") \%>\%
     owmr_as_tibble()
   map <- leaflet() \%>\% addTiles() \%>\%
     add_weather(
       owm_data,
       template = "<b>{{name}}</b>, {{temp}}°C",
       icon = owm_data$weather_icon
     )
}
}
