% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signTest.R
\name{signTest}
\alias{signTest}
\title{Permutatation-based one-sample t-tests}
\usage{
signTest(X, B = 1000, alternative = "two.sided", seed = NULL, mask = NULL, rand = FALSE)
}
\arguments{
\item{X}{Data matrix where rows represent the \eqn{m} variables and columns the \eqn{n} observations.}

\item{B}{Numeric value. Number of permutations, default to 1000.}

\item{alternative}{Character string. It refers to the alternative hypothesis, must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"lower"}.}

\item{seed}{Integer value. If you want to specify the seed. Default to to \code{NULL}}

\item{mask}{NIfTI file or character string. 3D array of logical values (i.e. \code{TRUE/FALSE} in/out of the brain). 
Alternatively it may be a (character) NIfTI file name. If \code{mask=NULL}, it is assumed that none of the voxels have to be excluded.}

\item{rand}{Boolean value. Default to \code{FALSE}. If \code{rand = TRUE}, the \eqn{p}-values are computed by \code{rowRanks}.}
}
\value{
Returns a list with the following objects: 
\describe{
   \item{Test}{Vector with length equals \eqn{m}. Observed two-samples t-tests, one for each \eqn{m} variable} 
   \item{Test_H0}{Matrix with dimensions \eqn{m \times B-1}. Test statistics under the null hypothesis}
   \item{pv}{Vector with length equals \eqn{m}. Observed \eqn{p}-values, one for each \eqn{m} variable}
   \item{pv_H0}{Matrix with dimensions \eqn{m \times B-1}. \eqn{p}-values under the null hypothesis}
}
}
\description{
Performs sign-flipped one-sample t-tests.
}
\examples{
X <- matrix(rnorm(100*20), ncol=20)
out <- signTest(X = X, alternative = "two.sided") 
}
\author{
Angela Andreella
}
