% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_level_functions.R
\name{compare}
\alias{compare}
\title{Running analysis runs on known substrates, predicted substrates, and both.}
\usage{
compare(matched_data, predictionDB, kseadb, ...)
}
\arguments{
\item{matched_data}{File path to summary statistic phosphoproteomics CSV data file
with an entry for each phosphopeptide. Required data file columns:
GN = gene name identifier that will be matched with prediction database, Peptide = unique peptide identifier
(for example, sequence with modifications), Phosphosites = comma-separated phosphorylation sites (eg. "T102,S105"),
pval= pairwise test p-value, fc= mean fold change, t= pairwise test t-statistic. pval and fc are used for results
reporting only, all others are important for database searching, calculation, and permutation testing.}

\item{predictionDB}{Input database whose prediction scores will be used for calculations. Required columns:
substrate_name= name of substrate corresponding to GN in summary_data, kinase_id = identifiers for kinase predictors,
position= phosphorylated residue number, score = numeric score for strength of prediction.}

\item{kseadb}{Optional KSEA database for filtering purposes. Containing substrate gene name "SUB_GENE"
and phosphorylated residue "SUB_MOD_RSD" in standard form (ie. T302).}

\item{...}{optional parameters to be passed on to downstream functions, including (default):
n_permutations (1000), seed (123), kin_ens_table (NULL). See \code{\link{run_on_matched}} for details.}
}
\description{
Performs up to three run_on_matched() runs on summary-prediction matcheddata from \code{get_matched_data()},
returning permutation significance score results.
If a KSEA database is provided for filtering and comparison, one full analysis will be performed on all
phosphosites, one on data with all known kinase substrates removed according to the provided KSEA database,
and one on known kinase substrates only.
}
\examples{
#Read in example summary statistics dataset from csv
summarydata_ex <- read.csv(system.file("extdata", "example_data1.csv", package="pKSEA"))

#Get matched data using predictions from NetworKIN
matched_data_ex <- get_matched_data(summarydata_ex, NetworKINPred_db)

#Perform comparative analysis using provided KSEAdb as filter
\dontrun{
compare_results_ex <- compare(matched_data_ex, kseadb = KSEAdb, n_permutations = 10)
}
}
