
<!-- README.md is generated from README.Rmd. Please edit that file -->

# pacta.multi.loanbook <a href="https://rmi-pacta.github.io/pacta.multi.loanbook/"><img src="man/figures/logo.png" align="right" height="31" /></a>

<!-- badges: start -->

[![Lifecycle:
experimental](https://img.shields.io/badge/lifecycle-experimental-orange.svg)](https://lifecycle.r-lib.org/articles/stages.html#experimental)
[![R-CMD-check](https://github.com/RMI-PACTA/pacta.multi.loanbook/actions/workflows/R-CMD-check.yaml/badge.svg)](https://github.com/RMI-PACTA/pacta.multi.loanbook/actions/workflows/R-CMD-check.yaml)
<!-- [![CRAN
status](https://www.r-pkg.org/badges/version/pacta.multi.loanbook)](https://CRAN.R-project.org/package=pacta.multi.loanbook) -->
[![codecov](https://codecov.io/gh/RMI-PACTA/pacta.multi.loanbook/graph/badge.svg)](https://app.codecov.io/gh/RMI-PACTA/pacta.multi.loanbook)
[![pacta.multi.loanbook status
badge](https://rmi-pacta.r-universe.dev/badges/pacta.multi.loanbook)](https://rmi-pacta.r-universe.dev/pacta.multi.loanbook)
<!-- badges: end -->

The `pacta.multi.loanbook` package offers a standardized, user-friendly
way to calculate climate alignment metrics for multiple loan books,
based on the PACTA methodology.

Designed for financial supervisory contexts, it simplifies climate
alignment analysis across many lending institutions. The package
streamlines steps to prevent repetition while allowing flexibility to
tailor the analysis for specific project needs, providing valuable
insights into transition alignment and risk.

<img src="man/figures/pml_readme_viz.png" width="100%" style="display: block; margin: auto auto auto 0;" />

## Installation

You can install the release version of the package by running the
following command in R:

``` r
install.packages("pacta.multi.loanbook")
```

You can install the development version of the package from GitHub with:

``` r
# install.packages("pak")
pak::pak("RMI-PACTA/pacta.multi.loanbook")
```

## Usage

Please consult the following resource for instructions on using the
package. The cookbook provides a detailed overview covering the setup of
the necessary software environment, obtaining and preparing input data,
running the analysis, and interpreting the results.

- [Cookbook](https://rmi-pacta.github.io/pacta.multi.loanbook//articles/cookbook_overview.html):
  A comprehensive guide for setting up, running and interpreting the
  analysis.
