% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/products.R
\name{paddle_create_product}
\alias{paddle_create_product}
\title{Create a Paddle Product}
\usage{
paddle_create_product(
  name,
  tax_category,
  description = NULL,
  type = NULL,
  image_url = NULL,
  custom_data = NULL
)
}
\arguments{
\item{name}{Name of the product. Required.}

\item{tax_category}{Character vector of tax categories to filter. One of `"digital-goods"`, `"ebooks`, `"implementation-services"`, `"professional-services"`, `"saas"`, `"software-programming-services"`, `"standard"`, `"training-services"`, and `"website-hosting"`. Required.}

\item{description}{Short description of the product. Optional.}

\item{type}{Character. Type of product (one of `"standard"` and `"custom"`). Optional, defaults to `"standard`.}

\item{image_url}{HTTPS URL for the product image (1:1 recommended). Optional.}

\item{custom_data}{Named list of your own structured key-value metadata. Optional.}
}
\value{
A list representing the newly created product.
}
\description{
Creates a new product in Paddle. You must specify a name and tax category
(chosen from a predefined set supported by Paddle).
}
\examples{
\dontshow{if (paddle_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
set_paddle_mode("sandbox")
result <- paddle_create_product(
 name = "My Product",
 tax_category = "digital-goods",
 description = "A great product"
 )
\dontshow{\}) # examplesIf}
}
