% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_records_by_hexagon.R
\name{get_records_by_hexagon}
\alias{get_records_by_hexagon}
\title{Retrieve species records aggregated by H3 hexagons}
\usage{
get_records_by_hexagon(
  species, aoi_sf, res = 6,
  providers = NULL, remove_duplicates = FALSE,
  date = NULL, expand_factor = 0.1, limit = 500
)
}
\arguments{
\item{species}{character vector. Species names to query.}

\item{aoi_sf}{sf object. Area of Interest polygon.}

\item{res}{integer. H3 resolution level (1–16). Default: 6.}

\item{providers}{character vector. Data providers to query. Default: NULL (all).}

\item{remove_duplicates}{logical. Remove duplicate records. Default: FALSE.}

\item{date}{character vector of length two. Start and end dates for filtering records.}

\item{expand_factor}{numeric. Expand AOI bounding box. Default: 0.1.}

\item{limit}{integer. Maximum number of occurrence records per species. Default: 500.}
}
\value{
sf object. H3 hex grid with species occurrence counts.
}
\description{
Downloads species occurrence data within a specified Area of Interest (AOI)
and aggregates these records into H3 hexagonal grid cells at a given resolution.
Returns an `sf` object with one polygon per hexagon and columns containing
species occurrence counts.
}
\details{
This function is useful for spatial biodiversity analyses where
data should be aggregated into a uniform spatial grid.
The H3 grid system enables multi-resolution analysis and efficient
spatial summarization of point occurrence data.
}
\examples{
\donttest{
library(sf)
nc <- sf::st_read(system.file("shape/nc.shp", package="sf"))
hex_counts <- get_records_by_hexagon(
  species = c("Lynx rufus"),
  aoi_sf = nc,
  res = 6,
  limit = 200
)
print(hex_counts)
}

}
