% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{arguments}
\alias{arguments}
\title{Arguments for "palasso"}
\arguments{
\item{y}{response\strong{:}
vector of length \eqn{n}}

\item{X}{covariates\strong{:}
list of matrices,
each with \eqn{n} rows (samples)
and \eqn{p} columns (variables)}

\item{max}{maximum number of non-zero coefficients\strong{:}
positive numeric, or \code{NULL} (no sparsity constraint)}

\item{...}{further arguments for \code{\link[glmnet]{cv.glmnet}} or
\code{\link[glmnet]{glmnet}}}

\item{x}{covariates\strong{:}
matrix with \eqn{n} rows (samples)
and \eqn{k * p} columns (variables)}

\item{args}{options for paired lasso\strong{:}
list of arguments
(output from \link{.dims} and \link{.args})}

\item{nfolds}{number of folds\strong{:}
positive integer
(\eqn{>= 10} recommended)}

\item{foldid}{fold identifiers\strong{:}
vector of length \eqn{n},
with entries from \eqn{1} to \code{nfolds}}

\item{cor}{correlation coefficients\strong{:}
list of \eqn{k} vectors of length \eqn{p}
(one vector for each covariate set with
one entry for each covariate)}

\item{lambda}{lambda sequence\strong{:}
vector of decreasing positive values}

\item{family}{model family\strong{:}
character "gaussian", "binomial", "poisson", or "cox"}

\item{type.measure}{...
loss function\strong{:}
character "deviance", "mse", "mae", "class", or "auc"}

\item{fit}{matrix with one row for each sample
("gaussian", "binomial" and "poisson"),
or one row for each fold (only "cox"),
and one column for each \code{lambda}
(output from \link{.fit})}

\item{cvm}{mean cross-validated loss\strong{:}
vector of same length as \code{lambda}
(output from \link{.loss})}
}
\description{
This page lists the arguments for the (internal) "palasso" function(s).
}
\keyword{internal}
