% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-ns.r
\name{sim.ns}
\alias{sim.ns}
\title{Simulating points from a Neyman-Scott point process}
\usage{
sim.ns(
  pars,
  lims,
  disp = "gaussian",
  child.dist = "pois",
  parents = NULL,
  child.info = NULL
)
}
\arguments{
\item{pars}{A named vector containing the values of the parameters
of the process that generates the points.}

\item{lims}{A matrix or list of matrices with two columns,
corresponding to the upper and lower limits of each dimension,
respectively. If a list, then each matrix provides the limits
for the corresponding pattern in \code{points}.}

\item{disp}{A character string indicating the distribution of
children around their parents. Use \code{"gaussian"} for
multivariate normal dispersion with standard deviation
\code{sigma}, or \code{"uniform"} for uniform dispersion within
distance \code{tau} of the parent.}

\item{child.dist}{The distribution of the number of children
generated by a randomly selected parent. For a Poisson
distribution, use \code{"pois"}; for a binomial distribution,
use \code{"binomx"}, where \code{"x"} is replaced by the fixed
value of the number of independent trials (e.g.,
\code{"binom5"} for a Binomial(5, p) distribution, and
\code{"binom50"} for a Binomial(50, p) distribution); and
\code{"twocamera"} for a child distribution appropriate for a
two-camera aerial survey.}

\item{parents}{An optional matrix containing locations of
parents. If this is provided, then the parameter \code{D} is
not required in \code{pars}. If this is not provided, then
parents are generated from a homogeneous Poisson point process
with intensity \code{D}.}

\item{child.info}{A list of further information that is required
about the distribution for the number of children generated by
parents. See `Details'.}
}
\value{
A list. The first component gives the Cartesian coordinates
    of the generated points. The second component returns the
    parent locations. A third component may provide sibling
    information.
}
\description{
Generates points from a Neyman-Scott point process using parameters
provided by the user.
}
\details{
For a list of possible parameter names, see \link{fit.ns}.

The \code{"child.info"} argument is required when \code{child.dist}
is set to \code{"twocamera"}. It must be a list that comprises (i) a
component named \code{w}, providing the halfwidth of the detection
zone; (ii) a component named \code{b}, providing the halfwidth of
the survey area; (iii) a component named \code{l}, providing the
time lag between cameras (in seconds); and (iv) a component named
\code{tau}, providing the mean dive-cycle duration. See Stevenson,
Borchers, and Fewster (2019) for details.
}
\examples{
## Simulating from a one-dimensional Thomas process.
data.thomas <- sim.ns(c(D = 10, lambda = 5, sigma = 0.025), lims = rbind(c(0, 1)))
## Simulating from a three-dimensional Matern process.
data.matern <- sim.ns(c(D = 10, lambda = 10, tau = 0.1), disp = "uniform",
                      lims = rbind(c(0, 1), c(0, 2), c(0, 3)))

}
\references{
Stevenson, B. C., Borchers, D. L., and Fewster,
    R. M. (2019) Cluster capture-recapture to account for
    identification uncertainty on aerial surveys of animal
    populations. \emph{Biometrics}, \strong{75}: 326--336.
}
