% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallelPlot.R
\name{setContinuousColorScale}
\alias{setContinuousColorScale}
\title{Lines colors}
\usage{
setContinuousColorScale(id, continuousCsId)
}
\arguments{
\item{id}{Output variable to read from (id which references the requested plot).}

\item{continuousCsId}{One of the available color scale ids
(\code{Viridis}, \code{Inferno}, \code{Magma}, \code{Plasma}, \code{Warm}, \code{Cool}, \code{Rainbow},
\code{CubehelixDefault}, \code{Blues},\code{Greens}, \code{Greys}, \code{Oranges}, \code{Purples},
\code{Reds}, \code{BuGn}, \code{BuPu}, \code{GnBu}, \code{OrRd}, \code{PuBuGn},\code{PuBu}, \code{PuRd}, \code{RdBu},
\code{RdPu}, \code{YlGnBu}, \code{YlGn}, \code{YlOrBr}, \code{YlOrRd}).}
}
\value{
No return value, called from shiny applications for side effects.
}
\description{
Tells which color scale to use when reference column is of type continuous.
}
\details{
If a column is defined as the reference (for example by clicking on its header),
a color scale is associated to this column.
Available color scale ids are: \code{Blues}, \code{RdBu}, \code{YlGnBu}, \code{YlOrRd}, \code{Reds}.
}
\examples{
 if(interactive() && require(shiny)) {
   library(shiny)
   library(parallelPlot)

   ui <- fluidPage(
     selectInput(
       "continuousCsSelect",
       "Continuous Color Scale:",
       choices = list(
         "Viridis" = "Viridis", "Inferno" = "Inferno", "Magma" = "Magma",
         "Plasma" = "Plasma", "Warm" = "Warm", "Cool" = "Cool", "Rainbow" ="Rainbow",
         "CubehelixDefault" = "CubehelixDefault", "Blues" = "Blues",
         "Greens" = "Greens", "Greys" = "Greys", "Oranges" = "Oranges",
         "Purples" = "Purples", "Reds" = "Reds", "BuGn" = "BuGn", "BuPu" = "BuPu",
         "GnBu" = "GnBu", "OrRd" = "OrRd", "PuBuGn" = "PuBuGn", "PuBu" = "PuBu",
         "PuRd" = "PuRd", "RdBu" = "RdBu", "RdPu" = "RdPu", "YlGnBu" = "YlGnBu",
         "YlGn" = "YlGn", "YlOrBr" = "YlOrBr", "YlOrRd" = "YlOrRd"
       ),
       selected = "Viridis"
     ),
     p("Selector controls used colors when reference column is of type continuous"),
     parallelPlotOutput("parPlot")
   )

   server <- function(input, output, session) {
       output$parPlot <- renderParallelPlot({
           parallelPlot(iris, refColumnDim = "Sepal.Length")
       })
       observeEvent(input$continuousCsSelect, {
           parallelPlot::setContinuousColorScale("parPlot", input$continuousCsSelect)
       })
   }

   shinyApp(ui, server)
 }

}
