% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_resids.R
\name{compare_resids}
\alias{compare_resids}
\title{Compare regression residual standard deviation across models}
\usage{
compare_resids(model_list)
}
\arguments{
\item{model_list}{A list of regression models.}
}
\value{
Vector of results. This includes the residual standard deviation from
 each model, the F statistic comparing the standard deviations, the numerator
 and denominator degrees of freedom, and the p-value.
}
\description{
Compare residual standard deviation across models. Works for linear regression
(\code{\link{lm}}) only.
}
\details{
This function currently supports comparing residual standard deviation from
two models. Residuals are assumed to be normally distributed (as also assumed
in the linear model itself) and are compared by an F test.
}
\examples{
 ##Simulate data

 N = 500

 m = rep(1:2, each=N)

 x1 = rnorm(n=N*2)
 x2 = rnorm(n=N*2)
 x3 = rnorm(n=N*2)

 y = x1 + x2 + x3 + rnorm(n=N*2)

 dat = data.frame(m, x1, x2, x3, y)

 m1 = lm(y ~ x1 + x2 + x3, data=dat, subset=m==1)
 m2 = lm(y ~ x1 + x2 + x3, data=dat, subset=m==2)

 mList = list(m1, m2)

 compare_resids(model_list = mList)

}
