% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lod.R
\name{lod}
\alias{lod}
\title{Singlepoint LOD score}
\usage{
lod(
  x,
  aff,
  model,
  rho = 0,
  liability = NULL,
  markers = NULL,
  maxOnly = NA,
  loopBreakers = NULL,
  peelOrder = NULL,
  verbose = FALSE
)
}
\arguments{
\item{x}{A \code{ped} object.}

\item{aff}{A vector naming the affected pedigree members, or a numeric vector
of length \code{pedsize(x)} with affection statuses for all pedigree members (2
= affected; 1 = unaffected; 0 = unknown). Alternatively, \code{aff} can be a
list of vectors, named \code{affected}, \code{unaffected} and \code{unknown}. It suffices
to give (any) two of these vectors.}

\item{model}{A \code{disModel} object, typically created with \code{\link[=diseaseModel]{diseaseModel()}}.}

\item{rho}{A number between 0 and 0.5 (inclusive); the hypothesised
recombination ratio between the marker and the disease locus.}

\item{liability}{NULL (default) or a vector of length \code{pedsize(x)} indicating
the liability class (a row number of \code{model$penetrances}) of each
individual.}

\item{markers}{A vector of marker names or indices referring to markers
attached to \code{x}. By default all markers are included.}

\item{maxOnly}{a logical indicating whether only the maximum LOD score should
be returned. By default this is always done if the number of markers is 1.}

\item{loopBreakers}{A vector of ID labels indicating loop breakers. (Only
relevant for inbred pedigrees.)}

\item{peelOrder}{For internal use.}

\item{verbose}{a logical: verbose output or not.}
}
\value{
If the number of markers is 1, or if \code{maxOnly = TRUE}, a single
number is returned.

Otherwise a \code{linkres} object, which is basically a data frame with columns
\code{CHROM}, \code{MARKER}, \code{MB} and \code{LOD}.
}
\description{
Calculates the singlepoint log of the odds (LOD) scores of a pedigree for the
specified markers, assuming a fixed recombination rate between the disease
and each marker locus.
}
\details{
The LOD score of a marker is defined as \deqn{LOD(\rho) = \log
\frac{L(\rho)}{L(0.5)}}{\% LOD(\rho) = \log L(\rho)/L(0.5)} where the
logarithms are base 10, and \eqn{L(\rho)} denotes the likelihood of the
observed marker genotypes given a recombination ratio \eqn{\rho} between the
marker and the disease locus.

The likelihoods are computed with the \strong{pedprobr} package.
}
\examples{

x = nuclearPed(2) |>
  addMarker(geno = c("1/2", "1/1", "1/2", "1/2"))

aff = c(2,1,2,2)
model = diseaseModel(model = "AD")

lod(x, aff, model)

}
\seealso{
\link{linkres}, \code{\link[=merlinLod]{merlinLod()}}, \code{\link[=diseaseModel]{diseaseModel()}}, \code{\link[=lodPeaks]{lodPeaks()}}
}
\author{
Magnus Dehli Vigeland
}
