% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\name{goodmanKruskal}
\alias{goodmanKruskal}
\alias{goodmanKruskal,Partition,Partition-method}
\alias{goodmanKruskal,PairCoefficients,missing-method}
\title{Goodman & Kruskal Index}
\usage{
goodmanKruskal(p, q)

\S4method{goodmanKruskal}{Partition,Partition}(p, q)

\S4method{goodmanKruskal}{PairCoefficients,missing}(p, q)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the index of Goodman and Kruskal
\deqn{\frac{N_{11}N_{00} - N_{10}N_{01}}{N_{11}N_{00} + N_{10}N_{01}}}
}
\section{Methods (by class)}{
\itemize{
\item \code{goodmanKruskal(p = Partition, q = Partition)}: Compute given two partitions

\item \code{goodmanKruskal(p = PairCoefficients, q = missing)}: Compute given the pair coefficients

}}
\examples{
isTRUE(all.equal(goodmanKruskal(new("Partition", c(0, 0, 0, 1, 1)), 
                                new("Partition", c(0, 0, 1, 1, 1))), 1/3))

}
\references{
\insertRef{Goodman1954}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
