% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_counting.R
\name{russelRao}
\alias{russelRao}
\alias{russelRao,Partition,Partition-method}
\alias{russelRao,PairCoefficients,missing-method}
\title{Russel & Rao Index}
\usage{
russelRao(p, q)

\S4method{russelRao}{Partition,Partition}(p, q)

\S4method{russelRao}{PairCoefficients,missing}(p, q = NULL)
}
\arguments{
\item{p}{The partition \eqn{P} or an instance of \linkS4class{PairCoefficients}}

\item{q}{The partition \eqn{Q} or NULL}
}
\description{
Compute the index of Russel and Rao
\deqn{\frac{N_{11}}{N}}
}
\section{Methods (by class)}{
\itemize{
\item \code{russelRao(p = Partition, q = Partition)}: Compute given two partitions

\item \code{russelRao(p = PairCoefficients, q = missing)}: Compute given the pair coefficients

}}
\examples{
isTRUE(all.equal(russelRao(new("Partition", c(0, 0, 0, 1, 1)), 
                           new("Partition", c(0, 0, 1, 1, 1))), 0.2))

}
\references{
\insertRef{Russel1940}{partitionComparison}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
