% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directors.R
\name{direct_k_cluster}
\alias{direct_k_cluster}
\title{Target based on K-means clustering}
\usage{
direct_k_cluster(
  .partition_step,
  algorithm = c("armadillo", "Hartigan-Wong", "Lloyd", "Forgy", "MacQueen"),
  search = c("binary", "linear"),
  init_k = NULL,
  seed = 1L
)
}
\arguments{
\item{.partition_step}{a \code{partition_step} object}

\item{algorithm}{The K-Means algorithm to use. The default is a fast version
of the LLoyd algorithm written in armadillo. The rest are options in
\code{\link[=kmeans]{kmeans()}}. In general, armadillo is fastest, but the other algorithms can
be faster in high dimensions.}

\item{search}{The search method. Binary search is generally more efficient
but linear search can be faster in very low dimensions.}

\item{init_k}{The initial k to test. If \code{NULL}, then the initial k is the
threshold times the number of variables.}

\item{seed}{The seed to set for reproducibility}
}
\value{
a \code{partition_step} object
}
\description{
Directors are functions that tell the partition algorithm what
to try to reduce.  \code{\link[=as_director]{as_director()}} is a helper function to create new
directors to be used in \code{partitioner}s. \code{partitioner}s can be created with
\code{\link[=as_partitioner]{as_partitioner()}}.

\code{direct_k_cluster()} assigns each variable to a cluster using
K-means. As the partition looks for the best reduction,
\code{direct_k_cluster()} iterates through values of \code{k} to assign clusters.
This search is handled by the binary search method by default and thus
does not necessarily need to fit every value of k.
}
\seealso{
Other directors: 
\code{\link{as_director}()},
\code{\link{direct_distance}()}
}
\concept{directors}
