% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mappings.R
\name{partition_scores}
\alias{partition_scores}
\alias{fitted.partition}
\title{Return the reduced data from a partition}
\usage{
partition_scores(object, ...)

\method{fitted}{partition}(object, ...)
}
\arguments{
\item{object}{a \code{partition} object}

\item{...}{not currently used (for S3 consistency with \code{fitted()})}
}
\value{
a tibble containing the reduced data for the partition
}
\description{
The reduced data is stored as \code{reduced_data} in the partition object and can
thus be returned by subsetting \code{object$reduced_data}. Alternatively, the
functions \code{partition_score()} and \code{fitted()} also return the reduced data.
}
\examples{
set.seed(123)
df <- simulate_block_data(c(3, 4, 5), lower_corr = .4, upper_corr = .6, n = 100)
# fit partition
prt <- partition(df, threshold = .6)


# three ways to retrieve reduced data
partition_scores(prt)
fitted(prt)
prt$reduced_data

}
