#' Extract data frame from a region series
#'
#' Extract the climatic information from a region series and organise them as
#' a data frame.
#'
#' To extract a data frame from a region slice, see [df_from_region_slice()].
#'
#' @param x climate time series generated with [region_series()]
#' @param xy a boolean whether x and y coordinates should be added
#' to the dataframe (default to TRUE)
#' @returns a data.frame where each cell each raster layer (i.e. timestep) is a
#' row, and the available variables are columns.
#'
#' @export

df_from_region_series <- function(x, xy = TRUE) {
  if (!is_region_series(x)) {
    stop("x is not a valid object generated by region_series")
  }
  times_all <- time_bp(x[[1]])
  for (i in seq_len(terra::nlyr(x[1]))) {
    x_slice <- slice_region_series(x, times_all[i])
    slice_df <- terra::as.data.frame(x_slice, xy = xy)
    slice_df$time_bp <- times_all[i]
    if (i == 1) {
      region_df <- slice_df
    } else {
      region_df <- rbind(region_df, slice_df)
    }
  }
  return(region_df)
}
