% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{exclude_by_velocity}
\alias{exclude_by_velocity}
\title{Remove trajectories entirely, based on velocity thresholds}
\usage{
exclude_by_velocity(obj_name, vel_min = NULL, vel_max = NULL)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that includes \code{"viewr"}}

\item{vel_min}{Default \code{NULL}. If a numeric is entered, trajectories
that have at least one observation with velocity less than \code{vel_min}
are removed.}

\item{vel_max}{Default \code{NULL}. If a numeric is entered, trajectories
that have at least one observation with velocity greater than
\code{vel_max} are removed.}
}
\value{
A new viewr object that is identical to the input object but now
excludes any trajectories that contain observations with velocity less than
\code{vel_min} (if specified) and/or velocity greater than \code{vel_max}
(if specified)
}
\description{
Remove trajectories from a viewr object that contain instances of velocity
known to be spurious.
}
\examples{
## Import and clean the example Motive data
motive_import_and_clean <-
  import_and_clean_viewr(
    file_name = system.file("extdata", "pathviewr_motive_example_data.csv",
                            package = 'pathviewr'),
    desired_percent = 50,
    max_frame_gap = "autodetect",
    span = 0.95
  )

## See the distribution of velocities
hist(motive_import_and_clean$velocity)

## Let's remove any trajectories that contain
## velocity < 2
motive_vel_filtered <-
  motive_import_and_clean \%>\%
  exclude_by_velocity(vel_min = 2)

## See how the distribution of velocities has changed
hist(motive_vel_filtered$velocity)
}
\author{
Vikram B. Baliga
}
