% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_generate_embed_url_for_registered_user_with_identity}
\alias{quicksight_generate_embed_url_for_registered_user_with_identity}
\title{Generates an embed URL that you can use to embed an Amazon QuickSight
experience in your website}
\usage{
quicksight_generate_embed_url_for_registered_user_with_identity(
  AwsAccountId,
  SessionLifetimeInMinutes = NULL,
  ExperienceConfiguration,
  AllowedDomains = NULL
)
}
\arguments{
\item{AwsAccountId}{[required] The ID of the Amazon Web Services registered user.}

\item{SessionLifetimeInMinutes}{The validity of the session in minutes.}

\item{ExperienceConfiguration}{[required]}

\item{AllowedDomains}{A list of domains to be allowed to generate the embed URL.}
}
\description{
Generates an embed URL that you can use to embed an Amazon QuickSight experience in your website. This action can be used for any type of user that is registered in an Amazon QuickSight account that uses IAM Identity Center for authentication. This API requires \href{https://docs.aws.amazon.com/singlesignon/latest/userguide/trustedidentitypropagation-overview.html#types-identity-enhanced-iam-role-sessions}{identity-enhanced IAM Role sessions} for the authenticated user that the API call is being made for.

See \url{https://www.paws-r-sdk.com/docs/quicksight_generate_embed_url_for_registered_user_with_identity/} for full documentation.
}
\keyword{internal}
