% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeoptimizer_operations.R
\name{computeoptimizer_get_idle_recommendations}
\alias{computeoptimizer_get_idle_recommendations}
\title{Returns idle resource recommendations}
\usage{
computeoptimizer_get_idle_recommendations(
  resourceArns = NULL,
  nextToken = NULL,
  maxResults = NULL,
  filters = NULL,
  accountIds = NULL,
  orderBy = NULL
)
}
\arguments{
\item{resourceArns}{The ARN that identifies the idle resource.}

\item{nextToken}{The token to advance to the next page of idle resource recommendations.}

\item{maxResults}{The maximum number of idle resource recommendations to return with a
single request.

To retrieve the remaining results, make another request with the
returned \code{nextToken} value.}

\item{filters}{An array of objects to specify a filter that returns a more specific
list of idle resource recommendations.}

\item{accountIds}{Return the idle resource recommendations to the specified Amazon Web
Services account IDs.

If your account is the management account or the delegated administrator
of an organization, use this parameter to return the idle resource
recommendations to specific member accounts.

You can only specify one account ID per request.}

\item{orderBy}{The order to sort the idle resource recommendations.}
}
\description{
Returns idle resource recommendations. Compute Optimizer generates recommendations for idle resources that meet a specific set of requirements. For more information, see \href{https://docs.aws.amazon.com/compute-optimizer/latest/ug/requirements.html}{Resource requirements} in the \emph{Compute Optimizer User Guide}

See \url{https://www.paws-r-sdk.com/docs/computeoptimizer_get_idle_recommendations/} for full documentation.
}
\keyword{internal}
