% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_vpc_block_public_access_exclusion}
\alias{ec2_delete_vpc_block_public_access_exclusion}
\title{Delete a VPC Block Public Access (BPA) exclusion}
\usage{
ec2_delete_vpc_block_public_access_exclusion(DryRun = NULL, ExclusionId)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ExclusionId}{[required] The ID of the exclusion.}
}
\description{
Delete a VPC Block Public Access (BPA) exclusion. A VPC BPA exclusion is a mode that can be applied to a single VPC or subnet that exempts it from the account’s BPA mode and will allow bidirectional or egress-only access. You can create BPA exclusions for VPCs and subnets even when BPA is not enabled on the account to ensure that there is no traffic disruption to the exclusions when VPC BPA is turned on. To learn more about VPC BPA, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/security-vpc-bpa.html}{Block public access to VPCs and subnets} in the \emph{Amazon VPC User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ec2_delete_vpc_block_public_access_exclusion/} for full documentation.
}
\keyword{internal}
