% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_declarative_policies_reports}
\alias{ec2_describe_declarative_policies_reports}
\title{Describes the metadata of an account status report, including the status
of the report}
\usage{
ec2_describe_declarative_policies_reports(
  DryRun = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  ReportIds = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}

\item{ReportIds}{One or more report IDs.}
}
\description{
Describes the metadata of an account status report, including the status of the report.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_declarative_policies_reports/} for full documentation.
}
\keyword{internal}
