% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_security_group_rules}
\alias{ec2_describe_security_group_rules}
\title{Describes one or more of your security group rules}
\usage{
ec2_describe_security_group_rules(
  Filters = NULL,
  SecurityGroupRuleIds = NULL,
  DryRun = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{Filters}{One or more filters.
\itemize{
\item \code{group-id} - The ID of the security group.
\item \code{security-group-rule-id} - The ID of the security group rule.
\item \code{tag}:\<key\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
}}

\item{SecurityGroupRuleIds}{The IDs of the security group rules.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{NextToken}{The token returned from a previous paginated request. Pagination
continues from the end of the items returned by the previous request.}

\item{MaxResults}{The maximum number of items to return for this request. To get the next
page of items, make another request with the token returned in the
output. This value can be between 5 and 1000. If this parameter is not
specified, then all items are returned. For more information, see
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination}{Pagination}.}
}
\description{
Describes one or more of your security group rules.

See \url{https://www.paws-r-sdk.com/docs/ec2_describe_security_group_rules/} for full documentation.
}
\keyword{internal}
