% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_create_model_copy_job}
\alias{bedrock_create_model_copy_job}
\title{Copies a model to another region so that it can be used there}
\usage{
bedrock_create_model_copy_job(
  sourceModelArn,
  targetModelName,
  modelKmsKeyId = NULL,
  targetModelTags = NULL,
  clientRequestToken = NULL
)
}
\arguments{
\item{sourceModelArn}{[required] The Amazon Resource Name (ARN) of the model to be copied.}

\item{targetModelName}{[required] A name for the copied model.}

\item{modelKmsKeyId}{The ARN of the KMS key that you use to encrypt the model copy.}

\item{targetModelTags}{Tags to associate with the target model. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html}{Tag resources}
in the \href{https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html}{Amazon Bedrock User Guide}.}

\item{clientRequestToken}{A unique, case-sensitive identifier to ensure that the API request
completes no more than one time. If this token matches a previous
request, Amazon Bedrock ignores the request, but does not return an
error. For more information, see \href{https://docs.aws.amazon.com/ec2/latest/devguide/ec2-api-idempotency.html}{Ensuring idempotency}.}
}
\description{
Copies a model to another region so that it can be used there. For more information, see \href{https://docs.aws.amazon.com/bedrock/latest/userguide/copy-model.html}{Copy models to be used in other regions} in the \href{https://docs.aws.amazon.com/bedrock/latest/userguide/what-is-bedrock.html}{Amazon Bedrock User Guide}.

See \url{https://www.paws-r-sdk.com/docs/bedrock_create_model_copy_job/} for full documentation.
}
\keyword{internal}
