% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_start_change_request_execution}
\alias{ssm_start_change_request_execution}
\title{Creates a change request for Change Manager}
\usage{
ssm_start_change_request_execution(
  ScheduledTime = NULL,
  DocumentName,
  DocumentVersion = NULL,
  Parameters = NULL,
  ChangeRequestName = NULL,
  ClientToken = NULL,
  AutoApprove = NULL,
  Runbooks,
  Tags = NULL,
  ScheduledEndTime = NULL,
  ChangeDetails = NULL
)
}
\arguments{
\item{ScheduledTime}{The date and time specified in the change request to run the Automation
runbooks.

The Automation runbooks specified for the runbook workflow can't run
until all required approvals for the change request have been received.}

\item{DocumentName}{[required] The name of the change template document to run during the runbook
workflow.}

\item{DocumentVersion}{The version of the change template document to run during the runbook
workflow.}

\item{Parameters}{A key-value map of parameters that match the declared parameters in the
change template document.}

\item{ChangeRequestName}{The name of the change request associated with the runbook workflow to
be run.}

\item{ClientToken}{The user-provided idempotency token. The token must be unique, is case
insensitive, enforces the UUID format, and can't be reused.}

\item{AutoApprove}{Indicates whether the change request can be approved automatically
without the need for manual approvals.

If \code{AutoApprovable} is enabled in a change template, then setting
\code{AutoApprove} to \code{true} in
\code{\link[=ssm_start_change_request_execution]{start_change_request_execution}}
creates a change request that bypasses approver review.

Change Calendar restrictions are not bypassed in this scenario. If the
state of an associated calendar is \code{CLOSED}, change freeze approvers
must still grant permission for this change request to run. If they
don't, the change won't be processed until the calendar state is again
\code{OPEN}.}

\item{Runbooks}{[required] Information about the Automation runbooks that are run during the
runbook workflow.

The Automation runbooks specified for the runbook workflow can't run
until all required approvals for the change request have been received.}

\item{Tags}{Optional metadata that you assign to a resource. You can specify a
maximum of five tags for a change request. Tags enable you to categorize
a resource in different ways, such as by purpose, owner, or environment.
For example, you might want to tag a change request to identify an
environment or target Amazon Web Services Region. In this case, you
could specify the following key-value pairs:
\itemize{
\item \verb{Key=Environment,Value=Production}
\item \verb{Key=Region,Value=us-east-2}
}

The \verb{Array Members} maximum value is reported as 1000. This number
includes capacity reserved for internal operations. When calling the
\code{\link[=ssm_start_change_request_execution]{start_change_request_execution}}
action, you can specify a maximum of 5 tags. You can, however, use the
\code{\link[=ssm_add_tags_to_resource]{add_tags_to_resource}} action to add up to a
total of 50 tags to an existing change request configuration.}

\item{ScheduledEndTime}{The time that the requester expects the runbook workflow related to the
change request to complete. The time is an estimate only that the
requester provides for reviewers.}

\item{ChangeDetails}{User-provided details about the change. If no details are provided,
content specified in the \strong{Template information} section of the
associated change template is added.}
}
\description{
Creates a change request for Change Manager. The Automation runbooks specified in the change request run only after all required approvals for the change request have been received.

See \url{https://www.paws-r-sdk.com/docs/ssm_start_change_request_execution/} for full documentation.
}
\keyword{internal}
