# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include arczonalshift_service.R
NULL

#' Cancel a zonal shift in Amazon Route 53 Application Recovery Controller
#'
#' @description
#' Cancel a zonal shift in Amazon Route 53 Application Recovery Controller. To cancel the zonal shift, specify the zonal shift ID.
#'
#' See [https://www.paws-r-sdk.com/docs/arczonalshift_cancel_zonal_shift/](https://www.paws-r-sdk.com/docs/arczonalshift_cancel_zonal_shift/) for full documentation.
#'
#' @param zonalShiftId &#91;required&#93; The internally-generated identifier of a zonal shift.
#'
#' @keywords internal
#'
#' @rdname arczonalshift_cancel_zonal_shift
arczonalshift_cancel_zonal_shift <- function(zonalShiftId) {
  op <- new_operation(
    name = "CancelZonalShift",
    http_method = "DELETE",
    http_path = "/zonalshifts/{zonalShiftId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .arczonalshift$cancel_zonal_shift_input(zonalShiftId = zonalShiftId)
  output <- .arczonalshift$cancel_zonal_shift_output()
  config <- get_config()
  svc <- .arczonalshift$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.arczonalshift$operations$cancel_zonal_shift <- arczonalshift_cancel_zonal_shift

#' A practice run configuration for zonal autoshift is required when you
#' enable zonal autoshift
#'
#' @description
#' A practice run configuration for zonal autoshift is required when you enable zonal autoshift. A practice run configuration includes specifications for blocked dates and blocked time windows, and for Amazon CloudWatch alarms that you create to use with practice runs. The alarms that you specify are an *outcome alarm*, to monitor application health during practice runs and, optionally, a *blocking alarm*, to block practice runs from starting.
#'
#' See [https://www.paws-r-sdk.com/docs/arczonalshift_create_practice_run_configuration/](https://www.paws-r-sdk.com/docs/arczonalshift_create_practice_run_configuration/) for full documentation.
#'
#' @param blockedDates Optionally, you can block Route 53 ARC from starting practice runs for a
#' resource on specific calendar dates.
#' 
#' The format for blocked dates is: YYYY-MM-DD. Keep in mind, when you
#' specify dates, that dates and times for practice runs are in UTC.
#' Separate multiple blocked dates with spaces.
#' 
#' For example, if you have an application update scheduled to launch on
#' May 1, 2024, and you don't want practice runs to shift traffic away at
#' that time, you could set a blocked date for `2024-05-01`.
#' @param blockedWindows Optionally, you can block Route 53 ARC from starting practice runs for
#' specific windows of days and times.
#' 
#' The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind,
#' when you specify dates, that dates and times for practice runs are in
#' UTC. Also, be aware of potential time adjustments that might be required
#' for daylight saving time differences. Separate multiple blocked windows
#' with spaces.
#' 
#' For example, say you run business report summaries three days a week.
#' For this scenario, you might set the following recurring days and times
#' as blocked windows, for example:
#' `MON-20:30-21:30 WED-20:30-21:30 FRI-20:30-21:30`.
#' @param blockingAlarms An Amazon CloudWatch alarm that you can specify for zonal autoshift
#' practice runs. This alarm blocks Route 53 ARC from starting practice run
#' zonal shifts, and ends a practice run that's in progress, when the alarm
#' is in an `ALARM` state.
#' @param outcomeAlarms &#91;required&#93; The *outcome alarm* for practice runs is a required Amazon CloudWatch
#' alarm that you specify that ends a practice run when the alarm is in an
#' `ALARM` state.
#' 
#' Configure the alarm to monitor the health of your application when
#' traffic is shifted away from an Availability Zone during each weekly
#' practice run. You should configure the alarm to go into an `ALARM` state
#' if your application is impacted by the zonal shift, and you want to stop
#' the zonal shift, to let traffic for the resource return to the
#' Availability Zone.
#' @param resourceIdentifier &#91;required&#93; The identifier of the resource that Amazon Web Services shifts traffic
#' for with a practice run zonal shift. The identifier is the Amazon
#' Resource Name (ARN) for the resource.
#' 
#' At this time, supported resources are Network Load Balancers and
#' Application Load Balancers with cross-zone load balancing turned off.
#'
#' @keywords internal
#'
#' @rdname arczonalshift_create_practice_run_configuration
arczonalshift_create_practice_run_configuration <- function(blockedDates = NULL, blockedWindows = NULL, blockingAlarms = NULL, outcomeAlarms, resourceIdentifier) {
  op <- new_operation(
    name = "CreatePracticeRunConfiguration",
    http_method = "POST",
    http_path = "/configuration",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .arczonalshift$create_practice_run_configuration_input(blockedDates = blockedDates, blockedWindows = blockedWindows, blockingAlarms = blockingAlarms, outcomeAlarms = outcomeAlarms, resourceIdentifier = resourceIdentifier)
  output <- .arczonalshift$create_practice_run_configuration_output()
  config <- get_config()
  svc <- .arczonalshift$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.arczonalshift$operations$create_practice_run_configuration <- arczonalshift_create_practice_run_configuration

#' Deletes the practice run configuration for a resource
#'
#' @description
#' Deletes the practice run configuration for a resource. Before you can delete a practice run configuration for a resource., you must disable zonal autoshift for the resource. Practice runs must be configured for zonal autoshift to be enabled.
#'
#' See [https://www.paws-r-sdk.com/docs/arczonalshift_delete_practice_run_configuration/](https://www.paws-r-sdk.com/docs/arczonalshift_delete_practice_run_configuration/) for full documentation.
#'
#' @param resourceIdentifier &#91;required&#93; The identifier for the resource that you want to delete the practice run
#' configuration for. The identifier is the Amazon Resource Name (ARN) for
#' the resource.
#'
#' @keywords internal
#'
#' @rdname arczonalshift_delete_practice_run_configuration
arczonalshift_delete_practice_run_configuration <- function(resourceIdentifier) {
  op <- new_operation(
    name = "DeletePracticeRunConfiguration",
    http_method = "DELETE",
    http_path = "/configuration/{resourceIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .arczonalshift$delete_practice_run_configuration_input(resourceIdentifier = resourceIdentifier)
  output <- .arczonalshift$delete_practice_run_configuration_output()
  config <- get_config()
  svc <- .arczonalshift$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.arczonalshift$operations$delete_practice_run_configuration <- arczonalshift_delete_practice_run_configuration

#' Returns the status of autoshift observer notification
#'
#' @description
#' Returns the status of autoshift observer notification. Autoshift observer notification enables you to be notified, through Amazon EventBridge, when there is an autoshift event for zonal autoshift.
#'
#' See [https://www.paws-r-sdk.com/docs/arczonalshift_get_autoshift_observer_notification_status/](https://www.paws-r-sdk.com/docs/arczonalshift_get_autoshift_observer_notification_status/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname arczonalshift_get_autoshift_observer_notification_status
arczonalshift_get_autoshift_observer_notification_status <- function() {
  op <- new_operation(
    name = "GetAutoshiftObserverNotificationStatus",
    http_method = "GET",
    http_path = "/autoshift-observer-notification",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .arczonalshift$get_autoshift_observer_notification_status_input()
  output <- .arczonalshift$get_autoshift_observer_notification_status_output()
  config <- get_config()
  svc <- .arczonalshift$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.arczonalshift$operations$get_autoshift_observer_notification_status <- arczonalshift_get_autoshift_observer_notification_status

#' Get information about a resource that's been registered for zonal shifts
#' with Amazon Route 53 Application Recovery Controller in this Amazon Web
#' Services Region
#'
#' @description
#' Get information about a resource that's been registered for zonal shifts with Amazon Route 53 Application Recovery Controller in this Amazon Web Services Region. Resources that are registered for zonal shifts are managed resources in Route 53 ARC. You can start zonal shifts and configure zonal autoshift for managed resources.
#'
#' See [https://www.paws-r-sdk.com/docs/arczonalshift_get_managed_resource/](https://www.paws-r-sdk.com/docs/arczonalshift_get_managed_resource/) for full documentation.
#'
#' @param resourceIdentifier &#91;required&#93; The identifier for the resource that Amazon Web Services shifts traffic
#' for. The identifier is the Amazon Resource Name (ARN) for the resource.
#' 
#' At this time, supported resources are Network Load Balancers and
#' Application Load Balancers with cross-zone load balancing turned off.
#'
#' @keywords internal
#'
#' @rdname arczonalshift_get_managed_resource
arczonalshift_get_managed_resource <- function(resourceIdentifier) {
  op <- new_operation(
    name = "GetManagedResource",
    http_method = "GET",
    http_path = "/managedresources/{resourceIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .arczonalshift$get_managed_resource_input(resourceIdentifier = resourceIdentifier)
  output <- .arczonalshift$get_managed_resource_output()
  config <- get_config()
  svc <- .arczonalshift$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.arczonalshift$operations$get_managed_resource <- arczonalshift_get_managed_resource

#' Returns a list of autoshifts for an Amazon Web Services Region
#'
#' @description
#' Returns a list of autoshifts for an Amazon Web Services Region. By default, the call returns only `ACTIVE` autoshifts. Optionally, you can specify the `status` parameter to return `COMPLETED` autoshifts.
#'
#' See [https://www.paws-r-sdk.com/docs/arczonalshift_list_autoshifts/](https://www.paws-r-sdk.com/docs/arczonalshift_list_autoshifts/) for full documentation.
#'
#' @param maxResults The number of objects that you want to return with this call.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param status The status of the autoshift.
#'
#' @keywords internal
#'
#' @rdname arczonalshift_list_autoshifts
arczonalshift_list_autoshifts <- function(maxResults = NULL, nextToken = NULL, status = NULL) {
  op <- new_operation(
    name = "ListAutoshifts",
    http_method = "GET",
    http_path = "/autoshifts",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .arczonalshift$list_autoshifts_input(maxResults = maxResults, nextToken = nextToken, status = status)
  output <- .arczonalshift$list_autoshifts_output()
  config <- get_config()
  svc <- .arczonalshift$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.arczonalshift$operations$list_autoshifts <- arczonalshift_list_autoshifts

#' Lists all the resources in your Amazon Web Services account in this
#' Amazon Web Services Region that are managed for zonal shifts in Amazon
#' Route 53 Application Recovery Controller, and information about them
#'
#' @description
#' Lists all the resources in your Amazon Web Services account in this Amazon Web Services Region that are managed for zonal shifts in Amazon Route 53 Application Recovery Controller, and information about them. The information includes the zonal autoshift status for the resource, as well as the Amazon Resource Name (ARN), the Availability Zones that each resource is deployed in, and the resource name.
#'
#' See [https://www.paws-r-sdk.com/docs/arczonalshift_list_managed_resources/](https://www.paws-r-sdk.com/docs/arczonalshift_list_managed_resources/) for full documentation.
#'
#' @param maxResults The number of objects that you want to return with this call.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#'
#' @keywords internal
#'
#' @rdname arczonalshift_list_managed_resources
arczonalshift_list_managed_resources <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListManagedResources",
    http_method = "GET",
    http_path = "/managedresources",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .arczonalshift$list_managed_resources_input(maxResults = maxResults, nextToken = nextToken)
  output <- .arczonalshift$list_managed_resources_output()
  config <- get_config()
  svc <- .arczonalshift$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.arczonalshift$operations$list_managed_resources <- arczonalshift_list_managed_resources

#' Lists all active and completed zonal shifts in Amazon Route 53
#' Application Recovery Controller in your Amazon Web Services account in
#' this Amazon Web Services Region
#'
#' @description
#' Lists all active and completed zonal shifts in Amazon Route 53 Application Recovery Controller in your Amazon Web Services account in this Amazon Web Services Region. [`list_zonal_shifts`][arczonalshift_list_zonal_shifts] returns customer-initiated zonal shifts, as well as practice run zonal shifts that Route 53 ARC started on your behalf for zonal autoshift.
#'
#' See [https://www.paws-r-sdk.com/docs/arczonalshift_list_zonal_shifts/](https://www.paws-r-sdk.com/docs/arczonalshift_list_zonal_shifts/) for full documentation.
#'
#' @param maxResults The number of objects that you want to return with this call.
#' @param nextToken Specifies that you want to receive the next page of results. Valid only
#' if you received a `NextToken` response in the previous request. If you
#' did, it indicates that more output is available. Set this parameter to
#' the value provided by the previous call's `NextToken` response to
#' request the next page of results.
#' @param resourceIdentifier The identifier for the resource that you want to list zonal shifts for.
#' The identifier is the Amazon Resource Name (ARN) for the resource.
#' @param status A status for a zonal shift.
#' 
#' The `Status` for a zonal shift can have one of the following values:
#' 
#' -   **ACTIVE**: The zonal shift has been started and active.
#' 
#' -   **EXPIRED**: The zonal shift has expired (the expiry time was
#'     exceeded).
#' 
#' -   **CANCELED**: The zonal shift was canceled.
#'
#' @keywords internal
#'
#' @rdname arczonalshift_list_zonal_shifts
arczonalshift_list_zonal_shifts <- function(maxResults = NULL, nextToken = NULL, resourceIdentifier = NULL, status = NULL) {
  op <- new_operation(
    name = "ListZonalShifts",
    http_method = "GET",
    http_path = "/zonalshifts",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items"),
    stream_api = FALSE
  )
  input <- .arczonalshift$list_zonal_shifts_input(maxResults = maxResults, nextToken = nextToken, resourceIdentifier = resourceIdentifier, status = status)
  output <- .arczonalshift$list_zonal_shifts_output()
  config <- get_config()
  svc <- .arczonalshift$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.arczonalshift$operations$list_zonal_shifts <- arczonalshift_list_zonal_shifts

#' You start a zonal shift to temporarily move load balancer traffic away
#' from an Availability Zone in an Amazon Web Services Region, to help your
#' application recover immediately, for example, from a developer's bad
#' code deployment or from an Amazon Web Services infrastructure failure in
#' a single Availability Zone
#'
#' @description
#' You start a zonal shift to temporarily move load balancer traffic away from an Availability Zone in an Amazon Web Services Region, to help your application recover immediately, for example, from a developer's bad code deployment or from an Amazon Web Services infrastructure failure in a single Availability Zone. You can start a zonal shift in Route 53 ARC only for managed resources in your Amazon Web Services account in an Amazon Web Services Region. Resources are automatically registered with Route 53 ARC by Amazon Web Services services.
#'
#' See [https://www.paws-r-sdk.com/docs/arczonalshift_start_zonal_shift/](https://www.paws-r-sdk.com/docs/arczonalshift_start_zonal_shift/) for full documentation.
#'
#' @param awayFrom &#91;required&#93; The Availability Zone (for example, `use1-az1`) that traffic is moved
#' away from for a resource when you start a zonal shift. Until the zonal
#' shift expires or you cancel it, traffic for the resource is instead
#' moved to other Availability Zones in the Amazon Web Services Region.
#' @param comment &#91;required&#93; A comment that you enter about the zonal shift. Only the latest comment
#' is retained; no comment history is maintained. A new comment overwrites
#' any existing comment string.
#' @param expiresIn &#91;required&#93; The length of time that you want a zonal shift to be active, which Route
#' 53 ARC converts to an expiry time (expiration time). Zonal shifts are
#' temporary. You can set a zonal shift to be active initially for up to
#' three days (72 hours).
#' 
#' If you want to still keep traffic away from an Availability Zone, you
#' can update the zonal shift and set a new expiration. You can also cancel
#' a zonal shift, before it expires, for example, if you're ready to
#' restore traffic to the Availability Zone.
#' 
#' To set a length of time for a zonal shift to be active, specify a whole
#' number, and then one of the following, with no space:
#' 
#' -   **A lowercase letter m:** To specify that the value is in minutes.
#' 
#' -   **A lowercase letter h:** To specify that the value is in hours.
#' 
#' For example: `20h` means the zonal shift expires in 20 hours. `120m`
#' means the zonal shift expires in 120 minutes (2 hours).
#' @param resourceIdentifier &#91;required&#93; The identifier for the resource that Amazon Web Services shifts traffic
#' for. The identifier is the Amazon Resource Name (ARN) for the resource.
#' 
#' At this time, supported resources are Network Load Balancers and
#' Application Load Balancers with cross-zone load balancing turned off.
#'
#' @keywords internal
#'
#' @rdname arczonalshift_start_zonal_shift
arczonalshift_start_zonal_shift <- function(awayFrom, comment, expiresIn, resourceIdentifier) {
  op <- new_operation(
    name = "StartZonalShift",
    http_method = "POST",
    http_path = "/zonalshifts",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .arczonalshift$start_zonal_shift_input(awayFrom = awayFrom, comment = comment, expiresIn = expiresIn, resourceIdentifier = resourceIdentifier)
  output <- .arczonalshift$start_zonal_shift_output()
  config <- get_config()
  svc <- .arczonalshift$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.arczonalshift$operations$start_zonal_shift <- arczonalshift_start_zonal_shift

#' Update the status of autoshift observer notification
#'
#' @description
#' Update the status of autoshift observer notification. Autoshift observer notification enables you to be notified, through Amazon EventBridge, when there is an autoshift event for zonal autoshift.
#'
#' See [https://www.paws-r-sdk.com/docs/arczonalshift_update_autoshift_observer_notification_status/](https://www.paws-r-sdk.com/docs/arczonalshift_update_autoshift_observer_notification_status/) for full documentation.
#'
#' @param status &#91;required&#93; The status to set for autoshift observer notification. If the status is
#' `ENABLED`, Route 53 ARC includes all autoshift events when you use the
#' Amazon EventBridge pattern `Autoshift In Progress`. When the status is
#' `DISABLED`, Route 53 ARC includes only autoshift events for autoshifts
#' when one or more of your resources is included in the autoshift.
#'
#' @keywords internal
#'
#' @rdname arczonalshift_update_autoshift_observer_notification_status
arczonalshift_update_autoshift_observer_notification_status <- function(status) {
  op <- new_operation(
    name = "UpdateAutoshiftObserverNotificationStatus",
    http_method = "PUT",
    http_path = "/autoshift-observer-notification",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .arczonalshift$update_autoshift_observer_notification_status_input(status = status)
  output <- .arczonalshift$update_autoshift_observer_notification_status_output()
  config <- get_config()
  svc <- .arczonalshift$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.arczonalshift$operations$update_autoshift_observer_notification_status <- arczonalshift_update_autoshift_observer_notification_status

#' Update a practice run configuration to change one or more of the
#' following: add, change, or remove the blocking alarm; change the outcome
#' alarm; or add, change, or remove blocking dates or time windows
#'
#' @description
#' Update a practice run configuration to change one or more of the following: add, change, or remove the blocking alarm; change the outcome alarm; or add, change, or remove blocking dates or time windows.
#'
#' See [https://www.paws-r-sdk.com/docs/arczonalshift_update_practice_run_configuration/](https://www.paws-r-sdk.com/docs/arczonalshift_update_practice_run_configuration/) for full documentation.
#'
#' @param blockedDates Add, change, or remove blocked dates for a practice run in zonal
#' autoshift.
#' 
#' Optionally, you can block practice runs for specific calendar dates. The
#' format for blocked dates is: YYYY-MM-DD. Keep in mind, when you specify
#' dates, that dates and times for practice runs are in UTC. Separate
#' multiple blocked dates with spaces.
#' 
#' For example, if you have an application update scheduled to launch on
#' May 1, 2024, and you don't want practice runs to shift traffic away at
#' that time, you could set a blocked date for `2024-05-01`.
#' @param blockedWindows Add, change, or remove windows of days and times for when you can,
#' optionally, block Route 53 ARC from starting a practice run for a
#' resource.
#' 
#' The format for blocked windows is: DAY:HH:SS-DAY:HH:SS. Keep in mind,
#' when you specify dates, that dates and times for practice runs are in
#' UTC. Also, be aware of potential time adjustments that might be required
#' for daylight saving time differences. Separate multiple blocked windows
#' with spaces.
#' 
#' For example, say you run business report summaries three days a week.
#' For this scenario, you might set the following recurring days and times
#' as blocked windows, for example:
#' `MON-20:30-21:30 WED-20:30-21:30 FRI-20:30-21:30`.
#' @param blockingAlarms Add, change, or remove the Amazon CloudWatch alarm that you optionally
#' specify as the blocking alarm for practice runs.
#' @param outcomeAlarms Specify a new the Amazon CloudWatch alarm as the outcome alarm for
#' practice runs.
#' @param resourceIdentifier &#91;required&#93; The identifier for the resource that you want to update the practice run
#' configuration for. The identifier is the Amazon Resource Name (ARN) for
#' the resource.
#'
#' @keywords internal
#'
#' @rdname arczonalshift_update_practice_run_configuration
arczonalshift_update_practice_run_configuration <- function(blockedDates = NULL, blockedWindows = NULL, blockingAlarms = NULL, outcomeAlarms = NULL, resourceIdentifier) {
  op <- new_operation(
    name = "UpdatePracticeRunConfiguration",
    http_method = "PATCH",
    http_path = "/configuration/{resourceIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .arczonalshift$update_practice_run_configuration_input(blockedDates = blockedDates, blockedWindows = blockedWindows, blockingAlarms = blockingAlarms, outcomeAlarms = outcomeAlarms, resourceIdentifier = resourceIdentifier)
  output <- .arczonalshift$update_practice_run_configuration_output()
  config <- get_config()
  svc <- .arczonalshift$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.arczonalshift$operations$update_practice_run_configuration <- arczonalshift_update_practice_run_configuration

#' The zonal autoshift configuration for a resource includes the practice
#' run configuration and the status for running autoshifts, zonal autoshift
#' status
#'
#' @description
#' The zonal autoshift configuration for a resource includes the practice run configuration and the status for running autoshifts, zonal autoshift status. When a resource has a practice run configuation, Route 53 ARC starts weekly zonal shifts for the resource, to shift traffic away from an Availability Zone. Weekly practice runs help you to make sure that your application can continue to operate normally with the loss of one Availability Zone.
#'
#' See [https://www.paws-r-sdk.com/docs/arczonalshift_update_zonal_autoshift_configuration/](https://www.paws-r-sdk.com/docs/arczonalshift_update_zonal_autoshift_configuration/) for full documentation.
#'
#' @param resourceIdentifier &#91;required&#93; The identifier for the resource that you want to update the zonal
#' autoshift configuration for. The identifier is the Amazon Resource Name
#' (ARN) for the resource.
#' @param zonalAutoshiftStatus &#91;required&#93; The zonal autoshift status for the resource that you want to update the
#' zonal autoshift configuration for. Choose `ENABLED` to authorize Amazon
#' Web Services to shift away resource traffic for an application from an
#' Availability Zone during events, on your behalf, to help reduce time to
#' recovery.
#'
#' @keywords internal
#'
#' @rdname arczonalshift_update_zonal_autoshift_configuration
arczonalshift_update_zonal_autoshift_configuration <- function(resourceIdentifier, zonalAutoshiftStatus) {
  op <- new_operation(
    name = "UpdateZonalAutoshiftConfiguration",
    http_method = "PUT",
    http_path = "/managedresources/{resourceIdentifier}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .arczonalshift$update_zonal_autoshift_configuration_input(resourceIdentifier = resourceIdentifier, zonalAutoshiftStatus = zonalAutoshiftStatus)
  output <- .arczonalshift$update_zonal_autoshift_configuration_output()
  config <- get_config()
  svc <- .arczonalshift$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.arczonalshift$operations$update_zonal_autoshift_configuration <- arczonalshift_update_zonal_autoshift_configuration

#' Update an active zonal shift in Amazon Route 53 Application Recovery
#' Controller in your Amazon Web Services account
#'
#' @description
#' Update an active zonal shift in Amazon Route 53 Application Recovery Controller in your Amazon Web Services account. You can update a zonal shift to set a new expiration, or edit or replace the comment for the zonal shift.
#'
#' See [https://www.paws-r-sdk.com/docs/arczonalshift_update_zonal_shift/](https://www.paws-r-sdk.com/docs/arczonalshift_update_zonal_shift/) for full documentation.
#'
#' @param comment A comment that you enter about the zonal shift. Only the latest comment
#' is retained; no comment history is maintained. A new comment overwrites
#' any existing comment string.
#' @param expiresIn The length of time that you want a zonal shift to be active, which Route
#' 53 ARC converts to an expiry time (expiration time). Zonal shifts are
#' temporary. You can set a zonal shift to be active initially for up to
#' three days (72 hours).
#' 
#' If you want to still keep traffic away from an Availability Zone, you
#' can update the zonal shift and set a new expiration. You can also cancel
#' a zonal shift, before it expires, for example, if you're ready to
#' restore traffic to the Availability Zone.
#' 
#' To set a length of time for a zonal shift to be active, specify a whole
#' number, and then one of the following, with no space:
#' 
#' -   **A lowercase letter m:** To specify that the value is in minutes.
#' 
#' -   **A lowercase letter h:** To specify that the value is in hours.
#' 
#' For example: `20h` means the zonal shift expires in 20 hours. `120m`
#' means the zonal shift expires in 120 minutes (2 hours).
#' @param zonalShiftId &#91;required&#93; The identifier of a zonal shift.
#'
#' @keywords internal
#'
#' @rdname arczonalshift_update_zonal_shift
arczonalshift_update_zonal_shift <- function(comment = NULL, expiresIn = NULL, zonalShiftId) {
  op <- new_operation(
    name = "UpdateZonalShift",
    http_method = "PATCH",
    http_path = "/zonalshifts/{zonalShiftId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .arczonalshift$update_zonal_shift_input(comment = comment, expiresIn = expiresIn, zonalShiftId = zonalShiftId)
  output <- .arczonalshift$update_zonal_shift_output()
  config <- get_config()
  svc <- .arczonalshift$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.arczonalshift$operations$update_zonal_shift <- arczonalshift_update_zonal_shift
