# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Route53 Recovery Control Config
#'
#' @description
#' Recovery Control Configuration API Reference for Amazon Route 53
#' Application Recovery Controller
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- route53recoverycontrolconfig(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- route53recoverycontrolconfig()
#' svc$create_cluster(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=route53recoverycontrolconfig_create_cluster]{create_cluster} \tab Create a new cluster\cr
#'  \link[=route53recoverycontrolconfig_create_control_panel]{create_control_panel} \tab Creates a new control panel\cr
#'  \link[=route53recoverycontrolconfig_create_routing_control]{create_routing_control} \tab Creates a new routing control\cr
#'  \link[=route53recoverycontrolconfig_create_safety_rule]{create_safety_rule} \tab Creates a safety rule in a control panel\cr
#'  \link[=route53recoverycontrolconfig_delete_cluster]{delete_cluster} \tab Delete a cluster\cr
#'  \link[=route53recoverycontrolconfig_delete_control_panel]{delete_control_panel} \tab Deletes a control panel\cr
#'  \link[=route53recoverycontrolconfig_delete_routing_control]{delete_routing_control} \tab Deletes a routing control\cr
#'  \link[=route53recoverycontrolconfig_delete_safety_rule]{delete_safety_rule} \tab Deletes a safety rule\cr
#'  \link[=route53recoverycontrolconfig_describe_cluster]{describe_cluster} \tab Display the details about a cluster\cr
#'  \link[=route53recoverycontrolconfig_describe_control_panel]{describe_control_panel} \tab Displays details about a control panel\cr
#'  \link[=route53recoverycontrolconfig_describe_routing_control]{describe_routing_control} \tab Displays details about a routing control\cr
#'  \link[=route53recoverycontrolconfig_describe_safety_rule]{describe_safety_rule} \tab Returns information about a safety rule\cr
#'  \link[=route53recoverycontrolconfig_get_resource_policy]{get_resource_policy} \tab Get information about the resource policy for a cluster\cr
#'  \link[=route53recoverycontrolconfig_list_associated_route_53_health_checks]{list_associated_route_53_health_checks} \tab Returns an array of all Amazon Route 53 health checks associated with a specific routing control\cr
#'  \link[=route53recoverycontrolconfig_list_clusters]{list_clusters} \tab Returns an array of all the clusters in an account\cr
#'  \link[=route53recoverycontrolconfig_list_control_panels]{list_control_panels} \tab Returns an array of control panels in an account or in a cluster\cr
#'  \link[=route53recoverycontrolconfig_list_routing_controls]{list_routing_controls} \tab Returns an array of routing controls for a control panel\cr
#'  \link[=route53recoverycontrolconfig_list_safety_rules]{list_safety_rules} \tab List the safety rules (the assertion rules and gating rules) that you've defined for the routing controls in a control panel\cr
#'  \link[=route53recoverycontrolconfig_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags for a resource\cr
#'  \link[=route53recoverycontrolconfig_tag_resource]{tag_resource} \tab Adds a tag to a resource\cr
#'  \link[=route53recoverycontrolconfig_untag_resource]{untag_resource} \tab Removes a tag from a resource\cr
#'  \link[=route53recoverycontrolconfig_update_control_panel]{update_control_panel} \tab Updates a control panel\cr
#'  \link[=route53recoverycontrolconfig_update_routing_control]{update_routing_control} \tab Updates a routing control\cr
#'  \link[=route53recoverycontrolconfig_update_safety_rule]{update_safety_rule} \tab Update a safety rule (an assertion rule or gating rule)
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname route53recoverycontrolconfig
#' @export
route53recoverycontrolconfig <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .route53recoverycontrolconfig$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.route53recoverycontrolconfig <- list()

.route53recoverycontrolconfig$operations <- list()

.route53recoverycontrolconfig$metadata <- list(
  service_name = "route53recoverycontrolconfig",
  endpoints = list("^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "route53-recovery-control-config.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "route53-recovery-control-config.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "route53-recovery-control-config.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "route53-recovery-control-config.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "route53-recovery-control-config.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "route53-recovery-control-config.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "route53-recovery-control-config.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Route53 Recovery Control Config",
  api_version = "2020-11-02",
  signing_name = "route53-recovery-control-config",
  json_version = "1.1",
  target_prefix = ""
)

.route53recoverycontrolconfig$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.route53recoverycontrolconfig$metadata, handlers, config, op)
}
