# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Access Analyzer
#'
#' @description
#' Identity and Access Management Access Analyzer helps you to set, verify,
#' and refine your IAM policies by providing a suite of capabilities. Its
#' features include findings for external and unused access, basic and
#' custom policy checks for validating policies, and policy generation to
#' generate fine-grained policies. To start using IAM Access Analyzer to
#' identify external or unused access, you first need to create an
#' analyzer.
#' 
#' **External access analyzers** help identify potential risks of accessing
#' resources by enabling you to identify any resource policies that grant
#' access to an external principal. It does this by using logic-based
#' reasoning to analyze resource-based policies in your Amazon Web Services
#' environment. An external principal can be another Amazon Web Services
#' account, a root user, an IAM user or role, a federated user, an Amazon
#' Web Services service, or an anonymous user. You can also use IAM Access
#' Analyzer to preview public and cross-account access to your resources
#' before deploying permissions changes.
#' 
#' **Unused access analyzers** help identify potential identity access
#' risks by enabling you to identify unused IAM roles, unused access keys,
#' unused console passwords, and IAM principals with unused service and
#' action-level permissions.
#' 
#' Beyond findings, IAM Access Analyzer provides basic and custom policy
#' checks to validate IAM policies before deploying permissions changes.
#' You can use policy generation to refine permissions by attaching a
#' policy generated using access activity logged in CloudTrail logs.
#' 
#' This guide describes the IAM Access Analyzer operations that you can
#' call programmatically. For general information about IAM Access
#' Analyzer, see [Identity and Access Management Access
#' Analyzer](https://docs.aws.amazon.com/IAM/latest/UserGuide/what-is-access-analyzer.html)
#' in the **IAM User Guide**.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- accessanalyzer(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- accessanalyzer()
#' svc$apply_archive_rule(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=accessanalyzer_apply_archive_rule]{apply_archive_rule} \tab Retroactively applies the archive rule to existing findings that meet the archive rule criteria\cr
#'  \link[=accessanalyzer_cancel_policy_generation]{cancel_policy_generation} \tab Cancels the requested policy generation\cr
#'  \link[=accessanalyzer_check_access_not_granted]{check_access_not_granted} \tab Checks whether the specified access isn't allowed by a policy\cr
#'  \link[=accessanalyzer_check_no_new_access]{check_no_new_access} \tab Checks whether new access is allowed for an updated policy when compared to the existing policy\cr
#'  \link[=accessanalyzer_check_no_public_access]{check_no_public_access} \tab Checks whether a resource policy can grant public access to the specified resource type\cr
#'  \link[=accessanalyzer_create_access_preview]{create_access_preview} \tab Creates an access preview that allows you to preview IAM Access Analyzer findings for your resource before deploying resource permissions\cr
#'  \link[=accessanalyzer_create_analyzer]{create_analyzer} \tab Creates an analyzer for your account\cr
#'  \link[=accessanalyzer_create_archive_rule]{create_archive_rule} \tab Creates an archive rule for the specified analyzer\cr
#'  \link[=accessanalyzer_delete_analyzer]{delete_analyzer} \tab Deletes the specified analyzer\cr
#'  \link[=accessanalyzer_delete_archive_rule]{delete_archive_rule} \tab Deletes the specified archive rule\cr
#'  \link[=accessanalyzer_generate_finding_recommendation]{generate_finding_recommendation} \tab Creates a recommendation for an unused permissions finding\cr
#'  \link[=accessanalyzer_get_access_preview]{get_access_preview} \tab Retrieves information about an access preview for the specified analyzer\cr
#'  \link[=accessanalyzer_get_analyzed_resource]{get_analyzed_resource} \tab Retrieves information about a resource that was analyzed\cr
#'  \link[=accessanalyzer_get_analyzer]{get_analyzer} \tab Retrieves information about the specified analyzer\cr
#'  \link[=accessanalyzer_get_archive_rule]{get_archive_rule} \tab Retrieves information about an archive rule\cr
#'  \link[=accessanalyzer_get_finding]{get_finding} \tab Retrieves information about the specified finding\cr
#'  \link[=accessanalyzer_get_finding_recommendation]{get_finding_recommendation} \tab Retrieves information about a finding recommendation for the specified analyzer\cr
#'  \link[=accessanalyzer_get_findings_statistics]{get_findings_statistics} \tab Retrieves a list of aggregated finding statistics for an external access or unused access analyzer\cr
#'  \link[=accessanalyzer_get_finding_v2]{get_finding_v2} \tab Retrieves information about the specified finding\cr
#'  \link[=accessanalyzer_get_generated_policy]{get_generated_policy} \tab Retrieves the policy that was generated using StartPolicyGeneration\cr
#'  \link[=accessanalyzer_list_access_preview_findings]{list_access_preview_findings} \tab Retrieves a list of access preview findings generated by the specified access preview\cr
#'  \link[=accessanalyzer_list_access_previews]{list_access_previews} \tab Retrieves a list of access previews for the specified analyzer\cr
#'  \link[=accessanalyzer_list_analyzed_resources]{list_analyzed_resources} \tab Retrieves a list of resources of the specified type that have been analyzed by the specified analyzer\cr
#'  \link[=accessanalyzer_list_analyzers]{list_analyzers} \tab Retrieves a list of analyzers\cr
#'  \link[=accessanalyzer_list_archive_rules]{list_archive_rules} \tab Retrieves a list of archive rules created for the specified analyzer\cr
#'  \link[=accessanalyzer_list_findings]{list_findings} \tab Retrieves a list of findings generated by the specified analyzer\cr
#'  \link[=accessanalyzer_list_findings_v2]{list_findings_v2} \tab Retrieves a list of findings generated by the specified analyzer\cr
#'  \link[=accessanalyzer_list_policy_generations]{list_policy_generations} \tab Lists all of the policy generations requested in the last seven days\cr
#'  \link[=accessanalyzer_list_tags_for_resource]{list_tags_for_resource} \tab Retrieves a list of tags applied to the specified resource\cr
#'  \link[=accessanalyzer_start_policy_generation]{start_policy_generation} \tab Starts the policy generation request\cr
#'  \link[=accessanalyzer_start_resource_scan]{start_resource_scan} \tab Immediately starts a scan of the policies applied to the specified resource\cr
#'  \link[=accessanalyzer_tag_resource]{tag_resource} \tab Adds a tag to the specified resource\cr
#'  \link[=accessanalyzer_untag_resource]{untag_resource} \tab Removes a tag from the specified resource\cr
#'  \link[=accessanalyzer_update_analyzer]{update_analyzer} \tab Modifies the configuration of an existing analyzer\cr
#'  \link[=accessanalyzer_update_archive_rule]{update_archive_rule} \tab Updates the criteria and values for the specified archive rule\cr
#'  \link[=accessanalyzer_update_findings]{update_findings} \tab Updates the status for the specified findings\cr
#'  \link[=accessanalyzer_validate_policy]{validate_policy} \tab Requests the validation of a policy and returns a list of findings
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname accessanalyzer
#' @export
accessanalyzer <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .accessanalyzer$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.accessanalyzer <- list()

.accessanalyzer$operations <- list()

.accessanalyzer$metadata <- list(
  service_name = "accessanalyzer",
  endpoints = list("^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "access-analyzer.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "access-analyzer.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "access-analyzer.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "access-analyzer.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "access-analyzer.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "access-analyzer.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "access-analyzer.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "AccessAnalyzer",
  api_version = "2019-11-01",
  signing_name = "access-analyzer",
  json_version = "",
  target_prefix = ""
)

.accessanalyzer$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.accessanalyzer$metadata, handlers, config, op)
}
