# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include clouddirectory_service.R
NULL

#' Adds a new Facet to an object
#'
#' @description
#' Adds a new Facet to an object. An object can have more than one facet applied on it.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_add_facet_to_object/](https://www.paws-r-sdk.com/docs/clouddirectory_add_facet_to_object/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory
#' where the object resides. For more information, see arns.
#' @param SchemaFacet &#91;required&#93; Identifiers for the facet that you are adding to the object. See
#' SchemaFacet for details.
#' @param ObjectAttributeList Attributes on the facet that you are adding to the object.
#' @param ObjectReference &#91;required&#93; A reference to the object you are adding the specified facet to.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_add_facet_to_object
clouddirectory_add_facet_to_object <- function(DirectoryArn, SchemaFacet, ObjectAttributeList = NULL, ObjectReference) {
  op <- new_operation(
    name = "AddFacetToObject",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/object/facets",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$add_facet_to_object_input(DirectoryArn = DirectoryArn, SchemaFacet = SchemaFacet, ObjectAttributeList = ObjectAttributeList, ObjectReference = ObjectReference)
  output <- .clouddirectory$add_facet_to_object_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$add_facet_to_object <- clouddirectory_add_facet_to_object

#' Copies the input published schema, at the specified version, into the
#' Directory with the same name and version as that of the published schema
#'
#' @description
#' Copies the input published schema, at the specified version, into the Directory with the same name and version as that of the published schema.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_apply_schema/](https://www.paws-r-sdk.com/docs/clouddirectory_apply_schema/) for full documentation.
#'
#' @param PublishedSchemaArn &#91;required&#93; Published schema Amazon Resource Name (ARN) that needs to be copied. For
#' more information, see arns.
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory
#' into which the schema is copied. For more information, see arns.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_apply_schema
clouddirectory_apply_schema <- function(PublishedSchemaArn, DirectoryArn) {
  op <- new_operation(
    name = "ApplySchema",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/schema/apply",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$apply_schema_input(PublishedSchemaArn = PublishedSchemaArn, DirectoryArn = DirectoryArn)
  output <- .clouddirectory$apply_schema_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$apply_schema <- clouddirectory_apply_schema

#' Attaches an existing object to another object
#'
#' @description
#' Attaches an existing object to another object. An object can be accessed in two ways:
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_attach_object/](https://www.paws-r-sdk.com/docs/clouddirectory_attach_object/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; Amazon Resource Name (ARN) that is associated with the Directory where
#' both objects reside. For more information, see arns.
#' @param ParentReference &#91;required&#93; The parent object reference.
#' @param ChildReference &#91;required&#93; The child object reference to be attached to the object.
#' @param LinkName &#91;required&#93; The link name with which the child object is attached to the parent.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_attach_object
clouddirectory_attach_object <- function(DirectoryArn, ParentReference, ChildReference, LinkName) {
  op <- new_operation(
    name = "AttachObject",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/object/attach",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$attach_object_input(DirectoryArn = DirectoryArn, ParentReference = ParentReference, ChildReference = ChildReference, LinkName = LinkName)
  output <- .clouddirectory$attach_object_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$attach_object <- clouddirectory_attach_object

#' Attaches a policy object to a regular object
#'
#' @description
#' Attaches a policy object to a regular object. An object can have a limited number of attached policies.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_attach_policy/](https://www.paws-r-sdk.com/docs/clouddirectory_attach_policy/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory
#' where both objects reside. For more information, see arns.
#' @param PolicyReference &#91;required&#93; The reference that is associated with the policy object.
#' @param ObjectReference &#91;required&#93; The reference that identifies the object to which the policy will be
#' attached.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_attach_policy
clouddirectory_attach_policy <- function(DirectoryArn, PolicyReference, ObjectReference) {
  op <- new_operation(
    name = "AttachPolicy",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/policy/attach",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$attach_policy_input(DirectoryArn = DirectoryArn, PolicyReference = PolicyReference, ObjectReference = ObjectReference)
  output <- .clouddirectory$attach_policy_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$attach_policy <- clouddirectory_attach_policy

#' Attaches the specified object to the specified index
#'
#' @description
#' Attaches the specified object to the specified index.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_attach_to_index/](https://www.paws-r-sdk.com/docs/clouddirectory_attach_to_index/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) of the directory where the object and
#' index exist.
#' @param IndexReference &#91;required&#93; A reference to the index that you are attaching the object to.
#' @param TargetReference &#91;required&#93; A reference to the object that you are attaching to the index.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_attach_to_index
clouddirectory_attach_to_index <- function(DirectoryArn, IndexReference, TargetReference) {
  op <- new_operation(
    name = "AttachToIndex",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/index/attach",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$attach_to_index_input(DirectoryArn = DirectoryArn, IndexReference = IndexReference, TargetReference = TargetReference)
  output <- .clouddirectory$attach_to_index_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$attach_to_index <- clouddirectory_attach_to_index

#' Attaches a typed link to a specified source and target object
#'
#' @description
#' Attaches a typed link to a specified source and target object. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_attach_typed_link/](https://www.paws-r-sdk.com/docs/clouddirectory_attach_typed_link/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) of the directory where you want to attach
#' the typed link.
#' @param SourceObjectReference &#91;required&#93; Identifies the source object that the typed link will attach to.
#' @param TargetObjectReference &#91;required&#93; Identifies the target object that the typed link will attach to.
#' @param TypedLinkFacet &#91;required&#93; Identifies the typed link facet that is associated with the typed link.
#' @param Attributes &#91;required&#93; A set of attributes that are associated with the typed link.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_attach_typed_link
clouddirectory_attach_typed_link <- function(DirectoryArn, SourceObjectReference, TargetObjectReference, TypedLinkFacet, Attributes) {
  op <- new_operation(
    name = "AttachTypedLink",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/typedlink/attach",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$attach_typed_link_input(DirectoryArn = DirectoryArn, SourceObjectReference = SourceObjectReference, TargetObjectReference = TargetObjectReference, TypedLinkFacet = TypedLinkFacet, Attributes = Attributes)
  output <- .clouddirectory$attach_typed_link_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$attach_typed_link <- clouddirectory_attach_typed_link

#' Performs all the read operations in a batch
#'
#' @description
#' Performs all the read operations in a batch.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_batch_read/](https://www.paws-r-sdk.com/docs/clouddirectory_batch_read/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory.
#' For more information, see arns.
#' @param Operations &#91;required&#93; A list of operations that are part of the batch.
#' @param ConsistencyLevel Represents the manner and timing in which the successful write or update
#' of an object is reflected in a subsequent read operation of that same
#' object.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_batch_read
clouddirectory_batch_read <- function(DirectoryArn, Operations, ConsistencyLevel = NULL) {
  op <- new_operation(
    name = "BatchRead",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/batchread",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$batch_read_input(DirectoryArn = DirectoryArn, Operations = Operations, ConsistencyLevel = ConsistencyLevel)
  output <- .clouddirectory$batch_read_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$batch_read <- clouddirectory_batch_read

#' Performs all the write operations in a batch
#'
#' @description
#' Performs all the write operations in a batch. Either all the operations succeed or none.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_batch_write/](https://www.paws-r-sdk.com/docs/clouddirectory_batch_write/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory.
#' For more information, see arns.
#' @param Operations &#91;required&#93; A list of operations that are part of the batch.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_batch_write
clouddirectory_batch_write <- function(DirectoryArn, Operations) {
  op <- new_operation(
    name = "BatchWrite",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/batchwrite",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$batch_write_input(DirectoryArn = DirectoryArn, Operations = Operations)
  output <- .clouddirectory$batch_write_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$batch_write <- clouddirectory_batch_write

#' Creates a Directory by copying the published schema into the directory
#'
#' @description
#' Creates a Directory by copying the published schema into the directory. A directory cannot be created without a schema.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_create_directory/](https://www.paws-r-sdk.com/docs/clouddirectory_create_directory/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the Directory. Should be unique per account, per region.
#' @param SchemaArn &#91;required&#93; The Amazon Resource Name (ARN) of the published schema that will be
#' copied into the data Directory. For more information, see arns.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_create_directory
clouddirectory_create_directory <- function(Name, SchemaArn) {
  op <- new_operation(
    name = "CreateDirectory",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/directory/create",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$create_directory_input(Name = Name, SchemaArn = SchemaArn)
  output <- .clouddirectory$create_directory_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$create_directory <- clouddirectory_create_directory

#' Creates a new Facet in a schema
#'
#' @description
#' Creates a new Facet in a schema. Facet creation is allowed only in development or applied schemas.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_create_facet/](https://www.paws-r-sdk.com/docs/clouddirectory_create_facet/) for full documentation.
#'
#' @param SchemaArn &#91;required&#93; The schema ARN in which the new Facet will be created. For more
#' information, see arns.
#' @param Name &#91;required&#93; The name of the Facet, which is unique for a given schema.
#' @param Attributes The attributes that are associated with the Facet.
#' @param ObjectType Specifies whether a given object created from this facet is of type
#' node, leaf node, policy or index.
#' 
#' -   Node: Can have multiple children but one parent.
#' 
#' 
#' -   Leaf node: Cannot have children but can have multiple parents.
#' 
#' 
#' -   Policy: Allows you to store a policy document and policy type. For
#'     more information, see
#'     [Policies](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies).
#' 
#' 
#' -   Index: Can be created with the Index API.
#' @param FacetStyle There are two different styles that you can define on any given facet,
#' `Static` and `Dynamic`. For static facets, all attributes must be
#' defined in the schema. For dynamic facets, attributes can be defined
#' during data plane operations.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_create_facet
clouddirectory_create_facet <- function(SchemaArn, Name, Attributes = NULL, ObjectType = NULL, FacetStyle = NULL) {
  op <- new_operation(
    name = "CreateFacet",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/facet/create",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$create_facet_input(SchemaArn = SchemaArn, Name = Name, Attributes = Attributes, ObjectType = ObjectType, FacetStyle = FacetStyle)
  output <- .clouddirectory$create_facet_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$create_facet <- clouddirectory_create_facet

#' Creates an index object
#'
#' @description
#' Creates an index object. See [Indexing and search](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/indexing_search.html) for more information.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_create_index/](https://www.paws-r-sdk.com/docs/clouddirectory_create_index/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The ARN of the directory where the index should be created.
#' @param OrderedIndexedAttributeList &#91;required&#93; Specifies the attributes that should be indexed on. Currently only a
#' single attribute is supported.
#' @param IsUnique &#91;required&#93; Indicates whether the attribute that is being indexed has unique values
#' or not.
#' @param ParentReference A reference to the parent object that contains the index object.
#' @param LinkName The name of the link between the parent object and the index object.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_create_index
clouddirectory_create_index <- function(DirectoryArn, OrderedIndexedAttributeList, IsUnique, ParentReference = NULL, LinkName = NULL) {
  op <- new_operation(
    name = "CreateIndex",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/index",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$create_index_input(DirectoryArn = DirectoryArn, OrderedIndexedAttributeList = OrderedIndexedAttributeList, IsUnique = IsUnique, ParentReference = ParentReference, LinkName = LinkName)
  output <- .clouddirectory$create_index_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$create_index <- clouddirectory_create_index

#' Creates an object in a Directory
#'
#' @description
#' Creates an object in a Directory. Additionally attaches the object to a parent, if a parent reference and `LinkName` is specified. An object is simply a collection of Facet attributes. You can also use this API call to create a policy object, if the facet from which you create the object is a policy facet.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_create_object/](https://www.paws-r-sdk.com/docs/clouddirectory_create_object/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory in
#' which the object will be created. For more information, see arns.
#' @param SchemaFacets &#91;required&#93; A list of schema facets to be associated with the object. Do not provide
#' minor version components. See SchemaFacet for details.
#' @param ObjectAttributeList The attribute map whose attribute ARN contains the key and attribute
#' value as the map value.
#' @param ParentReference If specified, the parent reference to which this object will be
#' attached.
#' @param LinkName The name of link that is used to attach this object to a parent.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_create_object
clouddirectory_create_object <- function(DirectoryArn, SchemaFacets, ObjectAttributeList = NULL, ParentReference = NULL, LinkName = NULL) {
  op <- new_operation(
    name = "CreateObject",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/object",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$create_object_input(DirectoryArn = DirectoryArn, SchemaFacets = SchemaFacets, ObjectAttributeList = ObjectAttributeList, ParentReference = ParentReference, LinkName = LinkName)
  output <- .clouddirectory$create_object_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$create_object <- clouddirectory_create_object

#' Creates a new schema in a development state
#'
#' @description
#' Creates a new schema in a development state. A schema can exist in three phases:
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_create_schema/](https://www.paws-r-sdk.com/docs/clouddirectory_create_schema/) for full documentation.
#'
#' @param Name &#91;required&#93; The name that is associated with the schema. This is unique to each
#' account and in each region.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_create_schema
clouddirectory_create_schema <- function(Name) {
  op <- new_operation(
    name = "CreateSchema",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/schema/create",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$create_schema_input(Name = Name)
  output <- .clouddirectory$create_schema_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$create_schema <- clouddirectory_create_schema

#' Creates a TypedLinkFacet
#'
#' @description
#' Creates a TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_create_typed_link_facet/](https://www.paws-r-sdk.com/docs/clouddirectory_create_typed_link_facet/) for full documentation.
#'
#' @param SchemaArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the schema. For
#' more information, see arns.
#' @param Facet &#91;required&#93; Facet structure that is associated with the typed link facet.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_create_typed_link_facet
clouddirectory_create_typed_link_facet <- function(SchemaArn, Facet) {
  op <- new_operation(
    name = "CreateTypedLinkFacet",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/typedlink/facet/create",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$create_typed_link_facet_input(SchemaArn = SchemaArn, Facet = Facet)
  output <- .clouddirectory$create_typed_link_facet_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$create_typed_link_facet <- clouddirectory_create_typed_link_facet

#' Deletes a directory
#'
#' @description
#' Deletes a directory. Only disabled directories can be deleted. A deleted directory cannot be undone. Exercise extreme caution when deleting directories.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_delete_directory/](https://www.paws-r-sdk.com/docs/clouddirectory_delete_directory/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The ARN of the directory to delete.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_delete_directory
clouddirectory_delete_directory <- function(DirectoryArn) {
  op <- new_operation(
    name = "DeleteDirectory",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/directory",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$delete_directory_input(DirectoryArn = DirectoryArn)
  output <- .clouddirectory$delete_directory_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$delete_directory <- clouddirectory_delete_directory

#' Deletes a given Facet
#'
#' @description
#' Deletes a given Facet. All attributes and Rules that are associated with the facet will be deleted. Only development schema facets are allowed deletion.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_delete_facet/](https://www.paws-r-sdk.com/docs/clouddirectory_delete_facet/) for full documentation.
#'
#' @param SchemaArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Facet. For
#' more information, see arns.
#' @param Name &#91;required&#93; The name of the facet to delete.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_delete_facet
clouddirectory_delete_facet <- function(SchemaArn, Name) {
  op <- new_operation(
    name = "DeleteFacet",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/facet/delete",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$delete_facet_input(SchemaArn = SchemaArn, Name = Name)
  output <- .clouddirectory$delete_facet_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$delete_facet <- clouddirectory_delete_facet

#' Deletes an object and its associated attributes
#'
#' @description
#' Deletes an object and its associated attributes. Only objects with no children and no parents can be deleted. The maximum number of attributes that can be deleted during an object deletion is 30. For more information, see [Amazon Cloud Directory Limits](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html).
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_delete_object/](https://www.paws-r-sdk.com/docs/clouddirectory_delete_object/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory
#' where the object resides. For more information, see arns.
#' @param ObjectReference &#91;required&#93; A reference that identifies the object.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_delete_object
clouddirectory_delete_object <- function(DirectoryArn, ObjectReference) {
  op <- new_operation(
    name = "DeleteObject",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/object/delete",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$delete_object_input(DirectoryArn = DirectoryArn, ObjectReference = ObjectReference)
  output <- .clouddirectory$delete_object_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$delete_object <- clouddirectory_delete_object

#' Deletes a given schema
#'
#' @description
#' Deletes a given schema. Schemas in a development and published state can only be deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_delete_schema/](https://www.paws-r-sdk.com/docs/clouddirectory_delete_schema/) for full documentation.
#'
#' @param SchemaArn &#91;required&#93; The Amazon Resource Name (ARN) of the development schema. For more
#' information, see arns.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_delete_schema
clouddirectory_delete_schema <- function(SchemaArn) {
  op <- new_operation(
    name = "DeleteSchema",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/schema",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$delete_schema_input(SchemaArn = SchemaArn)
  output <- .clouddirectory$delete_schema_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$delete_schema <- clouddirectory_delete_schema

#' Deletes a TypedLinkFacet
#'
#' @description
#' Deletes a TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_delete_typed_link_facet/](https://www.paws-r-sdk.com/docs/clouddirectory_delete_typed_link_facet/) for full documentation.
#'
#' @param SchemaArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the schema. For
#' more information, see arns.
#' @param Name &#91;required&#93; The unique name of the typed link facet.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_delete_typed_link_facet
clouddirectory_delete_typed_link_facet <- function(SchemaArn, Name) {
  op <- new_operation(
    name = "DeleteTypedLinkFacet",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/typedlink/facet/delete",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$delete_typed_link_facet_input(SchemaArn = SchemaArn, Name = Name)
  output <- .clouddirectory$delete_typed_link_facet_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$delete_typed_link_facet <- clouddirectory_delete_typed_link_facet

#' Detaches the specified object from the specified index
#'
#' @description
#' Detaches the specified object from the specified index.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_detach_from_index/](https://www.paws-r-sdk.com/docs/clouddirectory_detach_from_index/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) of the directory the index and object
#' exist in.
#' @param IndexReference &#91;required&#93; A reference to the index object.
#' @param TargetReference &#91;required&#93; A reference to the object being detached from the index.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_detach_from_index
clouddirectory_detach_from_index <- function(DirectoryArn, IndexReference, TargetReference) {
  op <- new_operation(
    name = "DetachFromIndex",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/index/detach",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$detach_from_index_input(DirectoryArn = DirectoryArn, IndexReference = IndexReference, TargetReference = TargetReference)
  output <- .clouddirectory$detach_from_index_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$detach_from_index <- clouddirectory_detach_from_index

#' Detaches a given object from the parent object
#'
#' @description
#' Detaches a given object from the parent object. The object that is to be detached from the parent is specified by the link name.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_detach_object/](https://www.paws-r-sdk.com/docs/clouddirectory_detach_object/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory
#' where objects reside. For more information, see arns.
#' @param ParentReference &#91;required&#93; The parent reference from which the object with the specified link name
#' is detached.
#' @param LinkName &#91;required&#93; The link name associated with the object that needs to be detached.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_detach_object
clouddirectory_detach_object <- function(DirectoryArn, ParentReference, LinkName) {
  op <- new_operation(
    name = "DetachObject",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/object/detach",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$detach_object_input(DirectoryArn = DirectoryArn, ParentReference = ParentReference, LinkName = LinkName)
  output <- .clouddirectory$detach_object_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$detach_object <- clouddirectory_detach_object

#' Detaches a policy from an object
#'
#' @description
#' Detaches a policy from an object.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_detach_policy/](https://www.paws-r-sdk.com/docs/clouddirectory_detach_policy/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory
#' where both objects reside. For more information, see arns.
#' @param PolicyReference &#91;required&#93; Reference that identifies the policy object.
#' @param ObjectReference &#91;required&#93; Reference that identifies the object whose policy object will be
#' detached.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_detach_policy
clouddirectory_detach_policy <- function(DirectoryArn, PolicyReference, ObjectReference) {
  op <- new_operation(
    name = "DetachPolicy",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/policy/detach",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$detach_policy_input(DirectoryArn = DirectoryArn, PolicyReference = PolicyReference, ObjectReference = ObjectReference)
  output <- .clouddirectory$detach_policy_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$detach_policy <- clouddirectory_detach_policy

#' Detaches a typed link from a specified source and target object
#'
#' @description
#' Detaches a typed link from a specified source and target object. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_detach_typed_link/](https://www.paws-r-sdk.com/docs/clouddirectory_detach_typed_link/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) of the directory where you want to detach
#' the typed link.
#' @param TypedLinkSpecifier &#91;required&#93; Used to accept a typed link specifier as input.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_detach_typed_link
clouddirectory_detach_typed_link <- function(DirectoryArn, TypedLinkSpecifier) {
  op <- new_operation(
    name = "DetachTypedLink",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/typedlink/detach",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$detach_typed_link_input(DirectoryArn = DirectoryArn, TypedLinkSpecifier = TypedLinkSpecifier)
  output <- .clouddirectory$detach_typed_link_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$detach_typed_link <- clouddirectory_detach_typed_link

#' Disables the specified directory
#'
#' @description
#' Disables the specified directory. Disabled directories cannot be read or written to. Only enabled directories can be disabled. Disabled directories may be reenabled.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_disable_directory/](https://www.paws-r-sdk.com/docs/clouddirectory_disable_directory/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The ARN of the directory to disable.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_disable_directory
clouddirectory_disable_directory <- function(DirectoryArn) {
  op <- new_operation(
    name = "DisableDirectory",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/directory/disable",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$disable_directory_input(DirectoryArn = DirectoryArn)
  output <- .clouddirectory$disable_directory_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$disable_directory <- clouddirectory_disable_directory

#' Enables the specified directory
#'
#' @description
#' Enables the specified directory. Only disabled directories can be enabled. Once enabled, the directory can then be read and written to.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_enable_directory/](https://www.paws-r-sdk.com/docs/clouddirectory_enable_directory/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The ARN of the directory to enable.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_enable_directory
clouddirectory_enable_directory <- function(DirectoryArn) {
  op <- new_operation(
    name = "EnableDirectory",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/directory/enable",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$enable_directory_input(DirectoryArn = DirectoryArn)
  output <- .clouddirectory$enable_directory_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$enable_directory <- clouddirectory_enable_directory

#' Returns current applied schema version ARN, including the minor version
#' in use
#'
#' @description
#' Returns current applied schema version ARN, including the minor version in use.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_get_applied_schema_version/](https://www.paws-r-sdk.com/docs/clouddirectory_get_applied_schema_version/) for full documentation.
#'
#' @param SchemaArn &#91;required&#93; The ARN of the applied schema.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_get_applied_schema_version
clouddirectory_get_applied_schema_version <- function(SchemaArn) {
  op <- new_operation(
    name = "GetAppliedSchemaVersion",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/schema/getappliedschema",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$get_applied_schema_version_input(SchemaArn = SchemaArn)
  output <- .clouddirectory$get_applied_schema_version_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$get_applied_schema_version <- clouddirectory_get_applied_schema_version

#' Retrieves metadata about a directory
#'
#' @description
#' Retrieves metadata about a directory.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_get_directory/](https://www.paws-r-sdk.com/docs/clouddirectory_get_directory/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The ARN of the directory.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_get_directory
clouddirectory_get_directory <- function(DirectoryArn) {
  op <- new_operation(
    name = "GetDirectory",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/directory/get",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$get_directory_input(DirectoryArn = DirectoryArn)
  output <- .clouddirectory$get_directory_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$get_directory <- clouddirectory_get_directory

#' Gets details of the Facet, such as facet name, attributes, Rules, or
#' ObjectType
#'
#' @description
#' Gets details of the Facet, such as facet name, attributes, Rules, or `ObjectType`. You can call this on all kinds of schema facets -- published, development, or applied.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_get_facet/](https://www.paws-r-sdk.com/docs/clouddirectory_get_facet/) for full documentation.
#'
#' @param SchemaArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Facet. For
#' more information, see arns.
#' @param Name &#91;required&#93; The name of the facet to retrieve.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_get_facet
clouddirectory_get_facet <- function(SchemaArn, Name) {
  op <- new_operation(
    name = "GetFacet",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/facet",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$get_facet_input(SchemaArn = SchemaArn, Name = Name)
  output <- .clouddirectory$get_facet_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$get_facet <- clouddirectory_get_facet

#' Retrieves attributes that are associated with a typed link
#'
#' @description
#' Retrieves attributes that are associated with a typed link.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_get_link_attributes/](https://www.paws-r-sdk.com/docs/clouddirectory_get_link_attributes/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory
#' where the typed link resides. For more information, see arns or [Typed
#' Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
#' @param TypedLinkSpecifier &#91;required&#93; Allows a typed link specifier to be accepted as input.
#' @param AttributeNames &#91;required&#93; A list of attribute names whose values will be retrieved.
#' @param ConsistencyLevel The consistency level at which to retrieve the attributes on a typed
#' link.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_get_link_attributes
clouddirectory_get_link_attributes <- function(DirectoryArn, TypedLinkSpecifier, AttributeNames, ConsistencyLevel = NULL) {
  op <- new_operation(
    name = "GetLinkAttributes",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/typedlink/attributes/get",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$get_link_attributes_input(DirectoryArn = DirectoryArn, TypedLinkSpecifier = TypedLinkSpecifier, AttributeNames = AttributeNames, ConsistencyLevel = ConsistencyLevel)
  output <- .clouddirectory$get_link_attributes_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$get_link_attributes <- clouddirectory_get_link_attributes

#' Retrieves attributes within a facet that are associated with an object
#'
#' @description
#' Retrieves attributes within a facet that are associated with an object.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_get_object_attributes/](https://www.paws-r-sdk.com/docs/clouddirectory_get_object_attributes/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory
#' where the object resides.
#' @param ObjectReference &#91;required&#93; Reference that identifies the object whose attributes will be retrieved.
#' @param ConsistencyLevel The consistency level at which to retrieve the attributes on an object.
#' @param SchemaFacet &#91;required&#93; Identifier for the facet whose attributes will be retrieved. See
#' SchemaFacet for details.
#' @param AttributeNames &#91;required&#93; List of attribute names whose values will be retrieved.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_get_object_attributes
clouddirectory_get_object_attributes <- function(DirectoryArn, ObjectReference, ConsistencyLevel = NULL, SchemaFacet, AttributeNames) {
  op <- new_operation(
    name = "GetObjectAttributes",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/object/attributes/get",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$get_object_attributes_input(DirectoryArn = DirectoryArn, ObjectReference = ObjectReference, ConsistencyLevel = ConsistencyLevel, SchemaFacet = SchemaFacet, AttributeNames = AttributeNames)
  output <- .clouddirectory$get_object_attributes_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$get_object_attributes <- clouddirectory_get_object_attributes

#' Retrieves metadata about an object
#'
#' @description
#' Retrieves metadata about an object.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_get_object_information/](https://www.paws-r-sdk.com/docs/clouddirectory_get_object_information/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The ARN of the directory being retrieved.
#' @param ObjectReference &#91;required&#93; A reference to the object.
#' @param ConsistencyLevel The consistency level at which to retrieve the object information.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_get_object_information
clouddirectory_get_object_information <- function(DirectoryArn, ObjectReference, ConsistencyLevel = NULL) {
  op <- new_operation(
    name = "GetObjectInformation",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/object/information",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$get_object_information_input(DirectoryArn = DirectoryArn, ObjectReference = ObjectReference, ConsistencyLevel = ConsistencyLevel)
  output <- .clouddirectory$get_object_information_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$get_object_information <- clouddirectory_get_object_information

#' Retrieves a JSON representation of the schema
#'
#' @description
#' Retrieves a JSON representation of the schema. See [JSON Schema Format](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json) for more information.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_get_schema_as_json/](https://www.paws-r-sdk.com/docs/clouddirectory_get_schema_as_json/) for full documentation.
#'
#' @param SchemaArn &#91;required&#93; The ARN of the schema to retrieve.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_get_schema_as_json
clouddirectory_get_schema_as_json <- function(SchemaArn) {
  op <- new_operation(
    name = "GetSchemaAsJson",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/schema/json",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$get_schema_as_json_input(SchemaArn = SchemaArn)
  output <- .clouddirectory$get_schema_as_json_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$get_schema_as_json <- clouddirectory_get_schema_as_json

#' Returns the identity attribute order for a specific TypedLinkFacet
#'
#' @description
#' Returns the identity attribute order for a specific TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_get_typed_link_facet_information/](https://www.paws-r-sdk.com/docs/clouddirectory_get_typed_link_facet_information/) for full documentation.
#'
#' @param SchemaArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the schema. For
#' more information, see arns.
#' @param Name &#91;required&#93; The unique name of the typed link facet.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_get_typed_link_facet_information
clouddirectory_get_typed_link_facet_information <- function(SchemaArn, Name) {
  op <- new_operation(
    name = "GetTypedLinkFacetInformation",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/typedlink/facet/get",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$get_typed_link_facet_information_input(SchemaArn = SchemaArn, Name = Name)
  output <- .clouddirectory$get_typed_link_facet_information_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$get_typed_link_facet_information <- clouddirectory_get_typed_link_facet_information

#' Lists schema major versions applied to a directory
#'
#' @description
#' Lists schema major versions applied to a directory. If `SchemaArn` is provided, lists the minor version.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_applied_schema_arns/](https://www.paws-r-sdk.com/docs/clouddirectory_list_applied_schema_arns/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The ARN of the directory you are listing.
#' @param SchemaArn The response for
#' [`list_applied_schema_arns`][clouddirectory_list_applied_schema_arns]
#' when this parameter is used will list all minor version ARNs for a major
#' version.
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of results to retrieve.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_applied_schema_arns
clouddirectory_list_applied_schema_arns <- function(DirectoryArn, SchemaArn = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAppliedSchemaArns",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/schema/applied",
    host_prefix = "",
    paginator = list(result_key = "SchemaArns", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_applied_schema_arns_input(DirectoryArn = DirectoryArn, SchemaArn = SchemaArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .clouddirectory$list_applied_schema_arns_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_applied_schema_arns <- clouddirectory_list_applied_schema_arns

#' Lists indices attached to the specified object
#'
#' @description
#' Lists indices attached to the specified object.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_attached_indices/](https://www.paws-r-sdk.com/docs/clouddirectory_list_attached_indices/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The ARN of the directory.
#' @param TargetReference &#91;required&#93; A reference to the object that has indices attached.
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of results to retrieve.
#' @param ConsistencyLevel The consistency level to use for this operation.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_attached_indices
clouddirectory_list_attached_indices <- function(DirectoryArn, TargetReference, NextToken = NULL, MaxResults = NULL, ConsistencyLevel = NULL) {
  op <- new_operation(
    name = "ListAttachedIndices",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/object/indices",
    host_prefix = "",
    paginator = list(result_key = "IndexAttachments", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_attached_indices_input(DirectoryArn = DirectoryArn, TargetReference = TargetReference, NextToken = NextToken, MaxResults = MaxResults, ConsistencyLevel = ConsistencyLevel)
  output <- .clouddirectory$list_attached_indices_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_attached_indices <- clouddirectory_list_attached_indices

#' Retrieves each Amazon Resource Name (ARN) of schemas in the development
#' state
#'
#' @description
#' Retrieves each Amazon Resource Name (ARN) of schemas in the development state.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_development_schema_arns/](https://www.paws-r-sdk.com/docs/clouddirectory_list_development_schema_arns/) for full documentation.
#'
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of results to retrieve.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_development_schema_arns
clouddirectory_list_development_schema_arns <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListDevelopmentSchemaArns",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/schema/development",
    host_prefix = "",
    paginator = list(result_key = "SchemaArns", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_development_schema_arns_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .clouddirectory$list_development_schema_arns_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_development_schema_arns <- clouddirectory_list_development_schema_arns

#' Lists directories created within an account
#'
#' @description
#' Lists directories created within an account.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_directories/](https://www.paws-r-sdk.com/docs/clouddirectory_list_directories/) for full documentation.
#'
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of results to retrieve.
#' @param state The state of the directories in the list. Can be either Enabled,
#' Disabled, or Deleted.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_directories
clouddirectory_list_directories <- function(NextToken = NULL, MaxResults = NULL, state = NULL) {
  op <- new_operation(
    name = "ListDirectories",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/directory/list",
    host_prefix = "",
    paginator = list(result_key = "Directories", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_directories_input(NextToken = NextToken, MaxResults = MaxResults, state = state)
  output <- .clouddirectory$list_directories_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_directories <- clouddirectory_list_directories

#' Retrieves attributes attached to the facet
#'
#' @description
#' Retrieves attributes attached to the facet.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_facet_attributes/](https://www.paws-r-sdk.com/docs/clouddirectory_list_facet_attributes/) for full documentation.
#'
#' @param SchemaArn &#91;required&#93; The ARN of the schema where the facet resides.
#' @param Name &#91;required&#93; The name of the facet whose attributes will be retrieved.
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of results to retrieve.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_facet_attributes
clouddirectory_list_facet_attributes <- function(SchemaArn, Name, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListFacetAttributes",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/facet/attributes",
    host_prefix = "",
    paginator = list(result_key = "Attributes", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_facet_attributes_input(SchemaArn = SchemaArn, Name = Name, NextToken = NextToken, MaxResults = MaxResults)
  output <- .clouddirectory$list_facet_attributes_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_facet_attributes <- clouddirectory_list_facet_attributes

#' Retrieves the names of facets that exist in a schema
#'
#' @description
#' Retrieves the names of facets that exist in a schema.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_facet_names/](https://www.paws-r-sdk.com/docs/clouddirectory_list_facet_names/) for full documentation.
#'
#' @param SchemaArn &#91;required&#93; The Amazon Resource Name (ARN) to retrieve facet names from.
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of results to retrieve.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_facet_names
clouddirectory_list_facet_names <- function(SchemaArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListFacetNames",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/facet/list",
    host_prefix = "",
    paginator = list(result_key = "FacetNames", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_facet_names_input(SchemaArn = SchemaArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .clouddirectory$list_facet_names_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_facet_names <- clouddirectory_list_facet_names

#' Returns a paginated list of all the incoming TypedLinkSpecifier
#' information for an object
#'
#' @description
#' Returns a paginated list of all the incoming TypedLinkSpecifier information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_incoming_typed_links/](https://www.paws-r-sdk.com/docs/clouddirectory_list_incoming_typed_links/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) of the directory where you want to list
#' the typed links.
#' @param ObjectReference &#91;required&#93; Reference that identifies the object whose attributes will be listed.
#' @param FilterAttributeRanges Provides range filters for multiple attributes. When providing ranges to
#' typed link selection, any inexact ranges must be specified at the end.
#' Any attributes that do not have a range specified are presumed to match
#' the entire range.
#' @param FilterTypedLink Filters are interpreted in the order of the attributes on the typed link
#' facet, not the order in which they are supplied to any API calls.
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of results to retrieve.
#' @param ConsistencyLevel The consistency level to execute the request at.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_incoming_typed_links
clouddirectory_list_incoming_typed_links <- function(DirectoryArn, ObjectReference, FilterAttributeRanges = NULL, FilterTypedLink = NULL, NextToken = NULL, MaxResults = NULL, ConsistencyLevel = NULL) {
  op <- new_operation(
    name = "ListIncomingTypedLinks",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/typedlink/incoming",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "LinkSpecifiers"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_incoming_typed_links_input(DirectoryArn = DirectoryArn, ObjectReference = ObjectReference, FilterAttributeRanges = FilterAttributeRanges, FilterTypedLink = FilterTypedLink, NextToken = NextToken, MaxResults = MaxResults, ConsistencyLevel = ConsistencyLevel)
  output <- .clouddirectory$list_incoming_typed_links_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_incoming_typed_links <- clouddirectory_list_incoming_typed_links

#' Lists objects attached to the specified index
#'
#' @description
#' Lists objects attached to the specified index.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_index/](https://www.paws-r-sdk.com/docs/clouddirectory_list_index/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The ARN of the directory that the index exists in.
#' @param RangesOnIndexedValues Specifies the ranges of indexed values that you want to query.
#' @param IndexReference &#91;required&#93; The reference to the index to list.
#' @param MaxResults The maximum number of objects in a single page to retrieve from the
#' index during a request. For more information, see [Amazon Cloud
#' Directory
#' Limits](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/limits.html).
#' @param NextToken The pagination token.
#' @param ConsistencyLevel The consistency level to execute the request at.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_index
clouddirectory_list_index <- function(DirectoryArn, RangesOnIndexedValues = NULL, IndexReference, MaxResults = NULL, NextToken = NULL, ConsistencyLevel = NULL) {
  op <- new_operation(
    name = "ListIndex",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/index/targets",
    host_prefix = "",
    paginator = list(result_key = "IndexAttachments", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_index_input(DirectoryArn = DirectoryArn, RangesOnIndexedValues = RangesOnIndexedValues, IndexReference = IndexReference, MaxResults = MaxResults, NextToken = NextToken, ConsistencyLevel = ConsistencyLevel)
  output <- .clouddirectory$list_index_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_index <- clouddirectory_list_index

#' Lists the major version families of each managed schema
#'
#' @description
#' Lists the major version families of each managed schema. If a major version ARN is provided as SchemaArn, the minor version revisions in that family are listed instead.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_managed_schema_arns/](https://www.paws-r-sdk.com/docs/clouddirectory_list_managed_schema_arns/) for full documentation.
#'
#' @param SchemaArn The response for ListManagedSchemaArns. When this parameter is used, all
#' minor version ARNs for a major version are listed.
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of results to retrieve.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_managed_schema_arns
clouddirectory_list_managed_schema_arns <- function(SchemaArn = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListManagedSchemaArns",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/schema/managed",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "SchemaArns"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_managed_schema_arns_input(SchemaArn = SchemaArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .clouddirectory$list_managed_schema_arns_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_managed_schema_arns <- clouddirectory_list_managed_schema_arns

#' Lists all attributes that are associated with an object
#'
#' @description
#' Lists all attributes that are associated with an object.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_object_attributes/](https://www.paws-r-sdk.com/docs/clouddirectory_list_object_attributes/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory
#' where the object resides. For more information, see arns.
#' @param ObjectReference &#91;required&#93; The reference that identifies the object whose attributes will be
#' listed.
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of items to be retrieved in a single call. This is an
#' approximate number.
#' @param ConsistencyLevel Represents the manner and timing in which the successful write or update
#' of an object is reflected in a subsequent read operation of that same
#' object.
#' @param FacetFilter Used to filter the list of object attributes that are associated with a
#' certain facet.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_object_attributes
clouddirectory_list_object_attributes <- function(DirectoryArn, ObjectReference, NextToken = NULL, MaxResults = NULL, ConsistencyLevel = NULL, FacetFilter = NULL) {
  op <- new_operation(
    name = "ListObjectAttributes",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/object/attributes",
    host_prefix = "",
    paginator = list(result_key = "Attributes", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_object_attributes_input(DirectoryArn = DirectoryArn, ObjectReference = ObjectReference, NextToken = NextToken, MaxResults = MaxResults, ConsistencyLevel = ConsistencyLevel, FacetFilter = FacetFilter)
  output <- .clouddirectory$list_object_attributes_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_object_attributes <- clouddirectory_list_object_attributes

#' Returns a paginated list of child objects that are associated with a
#' given object
#'
#' @description
#' Returns a paginated list of child objects that are associated with a given object.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_object_children/](https://www.paws-r-sdk.com/docs/clouddirectory_list_object_children/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory
#' where the object resides. For more information, see arns.
#' @param ObjectReference &#91;required&#93; The reference that identifies the object for which child objects are
#' being listed.
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of items to be retrieved in a single call. This is an
#' approximate number.
#' @param ConsistencyLevel Represents the manner and timing in which the successful write or update
#' of an object is reflected in a subsequent read operation of that same
#' object.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_object_children
clouddirectory_list_object_children <- function(DirectoryArn, ObjectReference, NextToken = NULL, MaxResults = NULL, ConsistencyLevel = NULL) {
  op <- new_operation(
    name = "ListObjectChildren",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/object/children",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_object_children_input(DirectoryArn = DirectoryArn, ObjectReference = ObjectReference, NextToken = NextToken, MaxResults = MaxResults, ConsistencyLevel = ConsistencyLevel)
  output <- .clouddirectory$list_object_children_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_object_children <- clouddirectory_list_object_children

#' Retrieves all available parent paths for any object type such as node,
#' leaf node, policy node, and index node objects
#'
#' @description
#' Retrieves all available parent paths for any object type such as node, leaf node, policy node, and index node objects. For more information about objects, see [Directory Structure](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directorystructure.html).
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_object_parent_paths/](https://www.paws-r-sdk.com/docs/clouddirectory_list_object_parent_paths/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The ARN of the directory to which the parent path applies.
#' @param ObjectReference &#91;required&#93; The reference that identifies the object whose parent paths are listed.
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of items to be retrieved in a single call. This is an
#' approximate number.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_object_parent_paths
clouddirectory_list_object_parent_paths <- function(DirectoryArn, ObjectReference, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListObjectParentPaths",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/object/parentpaths",
    host_prefix = "",
    paginator = list(result_key = "PathToObjectIdentifiersList", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_object_parent_paths_input(DirectoryArn = DirectoryArn, ObjectReference = ObjectReference, NextToken = NextToken, MaxResults = MaxResults)
  output <- .clouddirectory$list_object_parent_paths_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_object_parent_paths <- clouddirectory_list_object_parent_paths

#' Lists parent objects that are associated with a given object in
#' pagination fashion
#'
#' @description
#' Lists parent objects that are associated with a given object in pagination fashion.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_object_parents/](https://www.paws-r-sdk.com/docs/clouddirectory_list_object_parents/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory
#' where the object resides. For more information, see arns.
#' @param ObjectReference &#91;required&#93; The reference that identifies the object for which parent objects are
#' being listed.
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of items to be retrieved in a single call. This is an
#' approximate number.
#' @param ConsistencyLevel Represents the manner and timing in which the successful write or update
#' of an object is reflected in a subsequent read operation of that same
#' object.
#' @param IncludeAllLinksToEachParent When set to True, returns all ListObjectParentsResponse$ParentLinks.
#' There could be multiple links between a parent-child pair.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_object_parents
clouddirectory_list_object_parents <- function(DirectoryArn, ObjectReference, NextToken = NULL, MaxResults = NULL, ConsistencyLevel = NULL, IncludeAllLinksToEachParent = NULL) {
  op <- new_operation(
    name = "ListObjectParents",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/object/parent",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_object_parents_input(DirectoryArn = DirectoryArn, ObjectReference = ObjectReference, NextToken = NextToken, MaxResults = MaxResults, ConsistencyLevel = ConsistencyLevel, IncludeAllLinksToEachParent = IncludeAllLinksToEachParent)
  output <- .clouddirectory$list_object_parents_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_object_parents <- clouddirectory_list_object_parents

#' Returns policies attached to an object in pagination fashion
#'
#' @description
#' Returns policies attached to an object in pagination fashion.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_object_policies/](https://www.paws-r-sdk.com/docs/clouddirectory_list_object_policies/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory
#' where objects reside. For more information, see arns.
#' @param ObjectReference &#91;required&#93; Reference that identifies the object for which policies will be listed.
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of items to be retrieved in a single call. This is an
#' approximate number.
#' @param ConsistencyLevel Represents the manner and timing in which the successful write or update
#' of an object is reflected in a subsequent read operation of that same
#' object.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_object_policies
clouddirectory_list_object_policies <- function(DirectoryArn, ObjectReference, NextToken = NULL, MaxResults = NULL, ConsistencyLevel = NULL) {
  op <- new_operation(
    name = "ListObjectPolicies",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/object/policy",
    host_prefix = "",
    paginator = list(result_key = "AttachedPolicyIds", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_object_policies_input(DirectoryArn = DirectoryArn, ObjectReference = ObjectReference, NextToken = NextToken, MaxResults = MaxResults, ConsistencyLevel = ConsistencyLevel)
  output <- .clouddirectory$list_object_policies_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_object_policies <- clouddirectory_list_object_policies

#' Returns a paginated list of all the outgoing TypedLinkSpecifier
#' information for an object
#'
#' @description
#' Returns a paginated list of all the outgoing TypedLinkSpecifier information for an object. It also supports filtering by typed link facet and identity attributes. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_outgoing_typed_links/](https://www.paws-r-sdk.com/docs/clouddirectory_list_outgoing_typed_links/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) of the directory where you want to list
#' the typed links.
#' @param ObjectReference &#91;required&#93; A reference that identifies the object whose attributes will be listed.
#' @param FilterAttributeRanges Provides range filters for multiple attributes. When providing ranges to
#' typed link selection, any inexact ranges must be specified at the end.
#' Any attributes that do not have a range specified are presumed to match
#' the entire range.
#' @param FilterTypedLink Filters are interpreted in the order of the attributes defined on the
#' typed link facet, not the order they are supplied to any API calls.
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of results to retrieve.
#' @param ConsistencyLevel The consistency level to execute the request at.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_outgoing_typed_links
clouddirectory_list_outgoing_typed_links <- function(DirectoryArn, ObjectReference, FilterAttributeRanges = NULL, FilterTypedLink = NULL, NextToken = NULL, MaxResults = NULL, ConsistencyLevel = NULL) {
  op <- new_operation(
    name = "ListOutgoingTypedLinks",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/typedlink/outgoing",
    host_prefix = "",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken", result_key = "TypedLinkSpecifiers"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_outgoing_typed_links_input(DirectoryArn = DirectoryArn, ObjectReference = ObjectReference, FilterAttributeRanges = FilterAttributeRanges, FilterTypedLink = FilterTypedLink, NextToken = NextToken, MaxResults = MaxResults, ConsistencyLevel = ConsistencyLevel)
  output <- .clouddirectory$list_outgoing_typed_links_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_outgoing_typed_links <- clouddirectory_list_outgoing_typed_links

#' Returns all of the ObjectIdentifiers to which a given policy is attached
#'
#' @description
#' Returns all of the `ObjectIdentifiers` to which a given policy is attached.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_policy_attachments/](https://www.paws-r-sdk.com/docs/clouddirectory_list_policy_attachments/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory
#' where objects reside. For more information, see arns.
#' @param PolicyReference &#91;required&#93; The reference that identifies the policy object.
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of items to be retrieved in a single call. This is an
#' approximate number.
#' @param ConsistencyLevel Represents the manner and timing in which the successful write or update
#' of an object is reflected in a subsequent read operation of that same
#' object.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_policy_attachments
clouddirectory_list_policy_attachments <- function(DirectoryArn, PolicyReference, NextToken = NULL, MaxResults = NULL, ConsistencyLevel = NULL) {
  op <- new_operation(
    name = "ListPolicyAttachments",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/policy/attachment",
    host_prefix = "",
    paginator = list(result_key = "ObjectIdentifiers", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_policy_attachments_input(DirectoryArn = DirectoryArn, PolicyReference = PolicyReference, NextToken = NextToken, MaxResults = MaxResults, ConsistencyLevel = ConsistencyLevel)
  output <- .clouddirectory$list_policy_attachments_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_policy_attachments <- clouddirectory_list_policy_attachments

#' Lists the major version families of each published schema
#'
#' @description
#' Lists the major version families of each published schema. If a major version ARN is provided as `SchemaArn`, the minor version revisions in that family are listed instead.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_published_schema_arns/](https://www.paws-r-sdk.com/docs/clouddirectory_list_published_schema_arns/) for full documentation.
#'
#' @param SchemaArn The response for
#' [`list_published_schema_arns`][clouddirectory_list_published_schema_arns]
#' when this parameter is used will list all minor version ARNs for a major
#' version.
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of results to retrieve.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_published_schema_arns
clouddirectory_list_published_schema_arns <- function(SchemaArn = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPublishedSchemaArns",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/schema/published",
    host_prefix = "",
    paginator = list(result_key = "SchemaArns", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_published_schema_arns_input(SchemaArn = SchemaArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .clouddirectory$list_published_schema_arns_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_published_schema_arns <- clouddirectory_list_published_schema_arns

#' Returns tags for a resource
#'
#' @description
#' Returns tags for a resource. Tagging is currently supported only for directories with a limit of 50 tags per directory. All 50 tags are returned for a given directory with this API call.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/clouddirectory_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource. Tagging is only
#' supported for directories.
#' @param NextToken The pagination token. This is for future use. Currently pagination is
#' not supported for tagging.
#' @param MaxResults The `MaxResults` parameter sets the maximum number of results returned
#' in a single page. This is for future use and is not supported currently.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_tags_for_resource
clouddirectory_list_tags_for_resource <- function(ResourceArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/tags",
    host_prefix = "",
    paginator = list(result_key = "Tags", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_tags_for_resource_input(ResourceArn = ResourceArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .clouddirectory$list_tags_for_resource_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_tags_for_resource <- clouddirectory_list_tags_for_resource

#' Returns a paginated list of all attribute definitions for a particular
#' TypedLinkFacet
#'
#' @description
#' Returns a paginated list of all attribute definitions for a particular TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_typed_link_facet_attributes/](https://www.paws-r-sdk.com/docs/clouddirectory_list_typed_link_facet_attributes/) for full documentation.
#'
#' @param SchemaArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the schema. For
#' more information, see arns.
#' @param Name &#91;required&#93; The unique name of the typed link facet.
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of results to retrieve.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_typed_link_facet_attributes
clouddirectory_list_typed_link_facet_attributes <- function(SchemaArn, Name, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTypedLinkFacetAttributes",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/typedlink/facet/attributes",
    host_prefix = "",
    paginator = list(result_key = "Attributes", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_typed_link_facet_attributes_input(SchemaArn = SchemaArn, Name = Name, NextToken = NextToken, MaxResults = MaxResults)
  output <- .clouddirectory$list_typed_link_facet_attributes_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_typed_link_facet_attributes <- clouddirectory_list_typed_link_facet_attributes

#' Returns a paginated list of TypedLink facet names for a particular
#' schema
#'
#' @description
#' Returns a paginated list of `TypedLink` facet names for a particular schema. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_list_typed_link_facet_names/](https://www.paws-r-sdk.com/docs/clouddirectory_list_typed_link_facet_names/) for full documentation.
#'
#' @param SchemaArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the schema. For
#' more information, see arns.
#' @param NextToken The pagination token.
#' @param MaxResults The maximum number of results to retrieve.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_list_typed_link_facet_names
clouddirectory_list_typed_link_facet_names <- function(SchemaArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTypedLinkFacetNames",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/typedlink/facet/list",
    host_prefix = "",
    paginator = list(result_key = "FacetNames", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$list_typed_link_facet_names_input(SchemaArn = SchemaArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .clouddirectory$list_typed_link_facet_names_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$list_typed_link_facet_names <- clouddirectory_list_typed_link_facet_names

#' Lists all policies from the root of the Directory to the object
#' specified
#'
#' @description
#' Lists all policies from the root of the Directory to the object specified. If there are no policies present, an empty list is returned. If policies are present, and if some objects don't have the policies attached, it returns the `ObjectIdentifier` for such objects. If policies are present, it returns `ObjectIdentifier`, `policyId`, and `policyType`. Paths that don't lead to the root from the target object are ignored. For more information, see [Policies](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/key_concepts_directory.html#key_concepts_policies).
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_lookup_policy/](https://www.paws-r-sdk.com/docs/clouddirectory_lookup_policy/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory.
#' For more information, see arns.
#' @param ObjectReference &#91;required&#93; Reference that identifies the object whose policies will be looked up.
#' @param NextToken The token to request the next page of results.
#' @param MaxResults The maximum number of items to be retrieved in a single call. This is an
#' approximate number.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_lookup_policy
clouddirectory_lookup_policy <- function(DirectoryArn, ObjectReference, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "LookupPolicy",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/policy/lookup",
    host_prefix = "",
    paginator = list(result_key = "PolicyToPathList", output_token = "NextToken", input_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .clouddirectory$lookup_policy_input(DirectoryArn = DirectoryArn, ObjectReference = ObjectReference, NextToken = NextToken, MaxResults = MaxResults)
  output <- .clouddirectory$lookup_policy_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$lookup_policy <- clouddirectory_lookup_policy

#' Publishes a development schema with a major version and a recommended
#' minor version
#'
#' @description
#' Publishes a development schema with a major version and a recommended minor version.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_publish_schema/](https://www.paws-r-sdk.com/docs/clouddirectory_publish_schema/) for full documentation.
#'
#' @param DevelopmentSchemaArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the development
#' schema. For more information, see arns.
#' @param Version &#91;required&#93; The major version under which the schema will be published. Schemas have
#' both a major and minor version associated with them.
#' @param MinorVersion The minor version under which the schema will be published. This
#' parameter is recommended. Schemas have both a major and minor version
#' associated with them.
#' @param Name The new name under which the schema will be published. If this is not
#' provided, the development schema is considered.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_publish_schema
clouddirectory_publish_schema <- function(DevelopmentSchemaArn, Version, MinorVersion = NULL, Name = NULL) {
  op <- new_operation(
    name = "PublishSchema",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/schema/publish",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$publish_schema_input(DevelopmentSchemaArn = DevelopmentSchemaArn, Version = Version, MinorVersion = MinorVersion, Name = Name)
  output <- .clouddirectory$publish_schema_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$publish_schema <- clouddirectory_publish_schema

#' Allows a schema to be updated using JSON upload
#'
#' @description
#' Allows a schema to be updated using JSON upload. Only available for development schemas. See [JSON Schema Format](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/schemas_jsonformat.html#schemas_json) for more information.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_put_schema_from_json/](https://www.paws-r-sdk.com/docs/clouddirectory_put_schema_from_json/) for full documentation.
#'
#' @param SchemaArn &#91;required&#93; The ARN of the schema to update.
#' @param Document &#91;required&#93; The replacement JSON schema.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_put_schema_from_json
clouddirectory_put_schema_from_json <- function(SchemaArn, Document) {
  op <- new_operation(
    name = "PutSchemaFromJson",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/schema/json",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$put_schema_from_json_input(SchemaArn = SchemaArn, Document = Document)
  output <- .clouddirectory$put_schema_from_json_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$put_schema_from_json <- clouddirectory_put_schema_from_json

#' Removes the specified facet from the specified object
#'
#' @description
#' Removes the specified facet from the specified object.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_remove_facet_from_object/](https://www.paws-r-sdk.com/docs/clouddirectory_remove_facet_from_object/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The ARN of the directory in which the object resides.
#' @param SchemaFacet &#91;required&#93; The facet to remove. See SchemaFacet for details.
#' @param ObjectReference &#91;required&#93; A reference to the object to remove the facet from.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_remove_facet_from_object
clouddirectory_remove_facet_from_object <- function(DirectoryArn, SchemaFacet, ObjectReference) {
  op <- new_operation(
    name = "RemoveFacetFromObject",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/object/facets/delete",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$remove_facet_from_object_input(DirectoryArn = DirectoryArn, SchemaFacet = SchemaFacet, ObjectReference = ObjectReference)
  output <- .clouddirectory$remove_facet_from_object_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$remove_facet_from_object <- clouddirectory_remove_facet_from_object

#' An API operation for adding tags to a resource
#'
#' @description
#' An API operation for adding tags to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_tag_resource/](https://www.paws-r-sdk.com/docs/clouddirectory_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource. Tagging is only
#' supported for directories.
#' @param Tags &#91;required&#93; A list of tag key-value pairs.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_tag_resource
clouddirectory_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/tags/add",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .clouddirectory$tag_resource_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$tag_resource <- clouddirectory_tag_resource

#' An API operation for removing tags from a resource
#'
#' @description
#' An API operation for removing tags from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_untag_resource/](https://www.paws-r-sdk.com/docs/clouddirectory_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource. Tagging is only
#' supported for directories.
#' @param TagKeys &#91;required&#93; Keys of the tag that need to be removed from the resource.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_untag_resource
clouddirectory_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/tags/remove",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .clouddirectory$untag_resource_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$untag_resource <- clouddirectory_untag_resource

#' Does the following:
#'
#' @description
#' Does the following:
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_update_facet/](https://www.paws-r-sdk.com/docs/clouddirectory_update_facet/) for full documentation.
#'
#' @param SchemaArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Facet. For
#' more information, see arns.
#' @param Name &#91;required&#93; The name of the facet.
#' @param AttributeUpdates List of attributes that need to be updated in a given schema Facet. Each
#' attribute is followed by `AttributeAction`, which specifies the type of
#' update operation to perform.
#' @param ObjectType The object type that is associated with the facet. See
#' CreateFacetRequest$ObjectType for more details.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_update_facet
clouddirectory_update_facet <- function(SchemaArn, Name, AttributeUpdates = NULL, ObjectType = NULL) {
  op <- new_operation(
    name = "UpdateFacet",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/facet",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$update_facet_input(SchemaArn = SchemaArn, Name = Name, AttributeUpdates = AttributeUpdates, ObjectType = ObjectType)
  output <- .clouddirectory$update_facet_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$update_facet <- clouddirectory_update_facet

#' Updates a given typed link’s attributes
#'
#' @description
#' Updates a given typed link’s attributes. Attributes to be updated must not contribute to the typed link’s identity, as defined by its `IdentityAttributeOrder`.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_update_link_attributes/](https://www.paws-r-sdk.com/docs/clouddirectory_update_link_attributes/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory
#' where the updated typed link resides. For more information, see arns or
#' [Typed
#' Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
#' @param TypedLinkSpecifier &#91;required&#93; Allows a typed link specifier to be accepted as input.
#' @param AttributeUpdates &#91;required&#93; The attributes update structure.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_update_link_attributes
clouddirectory_update_link_attributes <- function(DirectoryArn, TypedLinkSpecifier, AttributeUpdates) {
  op <- new_operation(
    name = "UpdateLinkAttributes",
    http_method = "POST",
    http_path = "/amazonclouddirectory/2017-01-11/typedlink/attributes/update",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$update_link_attributes_input(DirectoryArn = DirectoryArn, TypedLinkSpecifier = TypedLinkSpecifier, AttributeUpdates = AttributeUpdates)
  output <- .clouddirectory$update_link_attributes_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$update_link_attributes <- clouddirectory_update_link_attributes

#' Updates a given object's attributes
#'
#' @description
#' Updates a given object's attributes.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_update_object_attributes/](https://www.paws-r-sdk.com/docs/clouddirectory_update_object_attributes/) for full documentation.
#'
#' @param DirectoryArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the Directory
#' where the object resides. For more information, see arns.
#' @param ObjectReference &#91;required&#93; The reference that identifies the object.
#' @param AttributeUpdates &#91;required&#93; The attributes update structure.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_update_object_attributes
clouddirectory_update_object_attributes <- function(DirectoryArn, ObjectReference, AttributeUpdates) {
  op <- new_operation(
    name = "UpdateObjectAttributes",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/object/update",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$update_object_attributes_input(DirectoryArn = DirectoryArn, ObjectReference = ObjectReference, AttributeUpdates = AttributeUpdates)
  output <- .clouddirectory$update_object_attributes_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$update_object_attributes <- clouddirectory_update_object_attributes

#' Updates the schema name with a new name
#'
#' @description
#' Updates the schema name with a new name. Only development schema names can be updated.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_update_schema/](https://www.paws-r-sdk.com/docs/clouddirectory_update_schema/) for full documentation.
#'
#' @param SchemaArn &#91;required&#93; The Amazon Resource Name (ARN) of the development schema. For more
#' information, see arns.
#' @param Name &#91;required&#93; The name of the schema.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_update_schema
clouddirectory_update_schema <- function(SchemaArn, Name) {
  op <- new_operation(
    name = "UpdateSchema",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/schema/update",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$update_schema_input(SchemaArn = SchemaArn, Name = Name)
  output <- .clouddirectory$update_schema_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$update_schema <- clouddirectory_update_schema

#' Updates a TypedLinkFacet
#'
#' @description
#' Updates a TypedLinkFacet. For more information, see [Typed Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_update_typed_link_facet/](https://www.paws-r-sdk.com/docs/clouddirectory_update_typed_link_facet/) for full documentation.
#'
#' @param SchemaArn &#91;required&#93; The Amazon Resource Name (ARN) that is associated with the schema. For
#' more information, see arns.
#' @param Name &#91;required&#93; The unique name of the typed link facet.
#' @param AttributeUpdates &#91;required&#93; Attributes update structure.
#' @param IdentityAttributeOrder &#91;required&#93; The order of identity attributes for the facet, from most significant to
#' least significant. The ability to filter typed links considers the order
#' that the attributes are defined on the typed link facet. When providing
#' ranges to a typed link selection, any inexact ranges must be specified
#' at the end. Any attributes that do not have a range specified are
#' presumed to match the entire range. Filters are interpreted in the order
#' of the attributes on the typed link facet, not the order in which they
#' are supplied to any API calls. For more information about identity
#' attributes, see [Typed
#' Links](https://docs.aws.amazon.com/clouddirectory/latest/developerguide/directory_objects_links.html#directory_objects_links_typedlink).
#'
#' @keywords internal
#'
#' @rdname clouddirectory_update_typed_link_facet
clouddirectory_update_typed_link_facet <- function(SchemaArn, Name, AttributeUpdates, IdentityAttributeOrder) {
  op <- new_operation(
    name = "UpdateTypedLinkFacet",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/typedlink/facet",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$update_typed_link_facet_input(SchemaArn = SchemaArn, Name = Name, AttributeUpdates = AttributeUpdates, IdentityAttributeOrder = IdentityAttributeOrder)
  output <- .clouddirectory$update_typed_link_facet_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$update_typed_link_facet <- clouddirectory_update_typed_link_facet

#' Upgrades a single directory in-place using the PublishedSchemaArn with
#' schema updates found in MinorVersion
#'
#' @description
#' Upgrades a single directory in-place using the `PublishedSchemaArn` with schema updates found in `MinorVersion`. Backwards-compatible minor version upgrades are instantaneously available for readers on all objects in the directory. Note: This is a synchronous API call and upgrades only one schema on a given directory per call. To upgrade multiple directories from one schema, you would need to call this API on each directory.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_upgrade_applied_schema/](https://www.paws-r-sdk.com/docs/clouddirectory_upgrade_applied_schema/) for full documentation.
#'
#' @param PublishedSchemaArn &#91;required&#93; The revision of the published schema to upgrade the directory to.
#' @param DirectoryArn &#91;required&#93; The ARN for the directory to which the upgraded schema will be applied.
#' @param DryRun Used for testing whether the major version schemas are backward
#' compatible or not. If schema compatibility fails, an exception would be
#' thrown else the call would succeed but no changes will be saved. This
#' parameter is optional.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_upgrade_applied_schema
clouddirectory_upgrade_applied_schema <- function(PublishedSchemaArn, DirectoryArn, DryRun = NULL) {
  op <- new_operation(
    name = "UpgradeAppliedSchema",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/schema/upgradeapplied",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$upgrade_applied_schema_input(PublishedSchemaArn = PublishedSchemaArn, DirectoryArn = DirectoryArn, DryRun = DryRun)
  output <- .clouddirectory$upgrade_applied_schema_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$upgrade_applied_schema <- clouddirectory_upgrade_applied_schema

#' Upgrades a published schema under a new minor version revision using the
#' current contents of DevelopmentSchemaArn
#'
#' @description
#' Upgrades a published schema under a new minor version revision using the current contents of `DevelopmentSchemaArn`.
#'
#' See [https://www.paws-r-sdk.com/docs/clouddirectory_upgrade_published_schema/](https://www.paws-r-sdk.com/docs/clouddirectory_upgrade_published_schema/) for full documentation.
#'
#' @param DevelopmentSchemaArn &#91;required&#93; The ARN of the development schema with the changes used for the upgrade.
#' @param PublishedSchemaArn &#91;required&#93; The ARN of the published schema to be upgraded.
#' @param MinorVersion &#91;required&#93; Identifies the minor version of the published schema that will be
#' created. This parameter is NOT optional.
#' @param DryRun Used for testing whether the Development schema provided is backwards
#' compatible, or not, with the publish schema provided by the user to be
#' upgraded. If schema compatibility fails, an exception would be thrown
#' else the call would succeed. This parameter is optional and defaults to
#' false.
#'
#' @keywords internal
#'
#' @rdname clouddirectory_upgrade_published_schema
clouddirectory_upgrade_published_schema <- function(DevelopmentSchemaArn, PublishedSchemaArn, MinorVersion, DryRun = NULL) {
  op <- new_operation(
    name = "UpgradePublishedSchema",
    http_method = "PUT",
    http_path = "/amazonclouddirectory/2017-01-11/schema/upgradepublished",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .clouddirectory$upgrade_published_schema_input(DevelopmentSchemaArn = DevelopmentSchemaArn, PublishedSchemaArn = PublishedSchemaArn, MinorVersion = MinorVersion, DryRun = DryRun)
  output <- .clouddirectory$upgrade_published_schema_output()
  config <- get_config()
  svc <- .clouddirectory$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.clouddirectory$operations$upgrade_published_schema <- clouddirectory_upgrade_published_schema
