% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{accessanalyzer}
\alias{accessanalyzer}
\title{Access Analyzer}
\usage{
accessanalyzer(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Identity and Access Management Access Analyzer helps you to set, verify,
and refine your IAM policies by providing a suite of capabilities. Its
features include findings for external and unused access, basic and
custom policy checks for validating policies, and policy generation to
generate fine-grained policies. To start using IAM Access Analyzer to
identify external or unused access, you first need to create an
analyzer.

\strong{External access analyzers} help identify potential risks of accessing
resources by enabling you to identify any resource policies that grant
access to an external principal. It does this by using logic-based
reasoning to analyze resource-based policies in your Amazon Web Services
environment. An external principal can be another Amazon Web Services
account, a root user, an IAM user or role, a federated user, an Amazon
Web Services service, or an anonymous user. You can also use IAM Access
Analyzer to preview public and cross-account access to your resources
before deploying permissions changes.

\strong{Unused access analyzers} help identify potential identity access
risks by enabling you to identify unused IAM roles, unused access keys,
unused console passwords, and IAM principals with unused service and
action-level permissions.

Beyond findings, IAM Access Analyzer provides basic and custom policy
checks to validate IAM policies before deploying permissions changes.
You can use policy generation to refine permissions by attaching a
policy generated using access activity logged in CloudTrail logs.

This guide describes the IAM Access Analyzer operations that you can
call programmatically. For general information about IAM Access
Analyzer, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/what-is-access-analyzer.html}{Identity and Access Management Access Analyzer}
in the \strong{IAM User Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- accessanalyzer(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.security.identity:accessanalyzer_apply_archive_rule]{apply_archive_rule} \tab Retroactively applies the archive rule to existing findings that meet the archive rule criteria\cr
\link[paws.security.identity:accessanalyzer_cancel_policy_generation]{cancel_policy_generation} \tab Cancels the requested policy generation\cr
\link[paws.security.identity:accessanalyzer_check_access_not_granted]{check_access_not_granted} \tab Checks whether the specified access isn't allowed by a policy\cr
\link[paws.security.identity:accessanalyzer_check_no_new_access]{check_no_new_access} \tab Checks whether new access is allowed for an updated policy when compared to the existing policy\cr
\link[paws.security.identity:accessanalyzer_check_no_public_access]{check_no_public_access} \tab Checks whether a resource policy can grant public access to the specified resource type\cr
\link[paws.security.identity:accessanalyzer_create_access_preview]{create_access_preview} \tab Creates an access preview that allows you to preview IAM Access Analyzer findings for your resource before deploying resource permissions\cr
\link[paws.security.identity:accessanalyzer_create_analyzer]{create_analyzer} \tab Creates an analyzer for your account\cr
\link[paws.security.identity:accessanalyzer_create_archive_rule]{create_archive_rule} \tab Creates an archive rule for the specified analyzer\cr
\link[paws.security.identity:accessanalyzer_delete_analyzer]{delete_analyzer} \tab Deletes the specified analyzer\cr
\link[paws.security.identity:accessanalyzer_delete_archive_rule]{delete_archive_rule} \tab Deletes the specified archive rule\cr
\link[paws.security.identity:accessanalyzer_generate_finding_recommendation]{generate_finding_recommendation} \tab Creates a recommendation for an unused permissions finding\cr
\link[paws.security.identity:accessanalyzer_get_access_preview]{get_access_preview} \tab Retrieves information about an access preview for the specified analyzer\cr
\link[paws.security.identity:accessanalyzer_get_analyzed_resource]{get_analyzed_resource} \tab Retrieves information about a resource that was analyzed\cr
\link[paws.security.identity:accessanalyzer_get_analyzer]{get_analyzer} \tab Retrieves information about the specified analyzer\cr
\link[paws.security.identity:accessanalyzer_get_archive_rule]{get_archive_rule} \tab Retrieves information about an archive rule\cr
\link[paws.security.identity:accessanalyzer_get_finding]{get_finding} \tab Retrieves information about the specified finding\cr
\link[paws.security.identity:accessanalyzer_get_finding_recommendation]{get_finding_recommendation} \tab Retrieves information about a finding recommendation for the specified analyzer\cr
\link[paws.security.identity:accessanalyzer_get_findings_statistics]{get_findings_statistics} \tab Retrieves a list of aggregated finding statistics for an external access or unused access analyzer\cr
\link[paws.security.identity:accessanalyzer_get_finding_v2]{get_finding_v2} \tab Retrieves information about the specified finding\cr
\link[paws.security.identity:accessanalyzer_get_generated_policy]{get_generated_policy} \tab Retrieves the policy that was generated using StartPolicyGeneration\cr
\link[paws.security.identity:accessanalyzer_list_access_preview_findings]{list_access_preview_findings} \tab Retrieves a list of access preview findings generated by the specified access preview\cr
\link[paws.security.identity:accessanalyzer_list_access_previews]{list_access_previews} \tab Retrieves a list of access previews for the specified analyzer\cr
\link[paws.security.identity:accessanalyzer_list_analyzed_resources]{list_analyzed_resources} \tab Retrieves a list of resources of the specified type that have been analyzed by the specified analyzer\cr
\link[paws.security.identity:accessanalyzer_list_analyzers]{list_analyzers} \tab Retrieves a list of analyzers\cr
\link[paws.security.identity:accessanalyzer_list_archive_rules]{list_archive_rules} \tab Retrieves a list of archive rules created for the specified analyzer\cr
\link[paws.security.identity:accessanalyzer_list_findings]{list_findings} \tab Retrieves a list of findings generated by the specified analyzer\cr
\link[paws.security.identity:accessanalyzer_list_findings_v2]{list_findings_v2} \tab Retrieves a list of findings generated by the specified analyzer\cr
\link[paws.security.identity:accessanalyzer_list_policy_generations]{list_policy_generations} \tab Lists all of the policy generations requested in the last seven days\cr
\link[paws.security.identity:accessanalyzer_list_tags_for_resource]{list_tags_for_resource} \tab Retrieves a list of tags applied to the specified resource\cr
\link[paws.security.identity:accessanalyzer_start_policy_generation]{start_policy_generation} \tab Starts the policy generation request\cr
\link[paws.security.identity:accessanalyzer_start_resource_scan]{start_resource_scan} \tab Immediately starts a scan of the policies applied to the specified resource\cr
\link[paws.security.identity:accessanalyzer_tag_resource]{tag_resource} \tab Adds a tag to the specified resource\cr
\link[paws.security.identity:accessanalyzer_untag_resource]{untag_resource} \tab Removes a tag from the specified resource\cr
\link[paws.security.identity:accessanalyzer_update_analyzer]{update_analyzer} \tab Modifies the configuration of an existing analyzer\cr
\link[paws.security.identity:accessanalyzer_update_archive_rule]{update_archive_rule} \tab Updates the criteria and values for the specified archive rule\cr
\link[paws.security.identity:accessanalyzer_update_findings]{update_findings} \tab Updates the status for the specified findings\cr
\link[paws.security.identity:accessanalyzer_validate_policy]{validate_policy} \tab Requests the validation of a policy and returns a list of findings
}
}

\examples{
\dontrun{
svc <- accessanalyzer()
svc$apply_archive_rule(
  Foo = 123
)
}

}
