% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{connectcases}
\alias{connectcases}
\title{Amazon Connect Cases}
\usage{
connectcases(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
\itemize{
\item \href{https://docs.aws.amazon.com/connect/latest/APIReference/API_Operations_Amazon_Connect_Cases.html}{Cases actions}
\item \href{https://docs.aws.amazon.com/connect/latest/APIReference/API_Types_Amazon_Connect_Cases.html}{Cases data types}
}

With Amazon Connect Cases, your agents can track and manage customer
issues that require multiple interactions, follow-up tasks, and teams in
your contact center. A case represents a customer issue. It records the
issue, the steps and interactions taken to resolve the issue, and the
outcome. For more information, see \href{https://docs.aws.amazon.com/connect/latest/adminguide/cases.html}{Amazon Connect Cases}
in the \emph{Amazon Connect Administrator Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- connectcases(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.customer.engagement:connectcases_batch_get_case_rule]{batch_get_case_rule} \tab Gets a batch of case rules\cr
\link[paws.customer.engagement:connectcases_batch_get_field]{batch_get_field} \tab Returns the description for the list of fields in the request parameters\cr
\link[paws.customer.engagement:connectcases_batch_put_field_options]{batch_put_field_options} \tab Creates and updates a set of field options for a single select field in a Cases domain\cr
\link[paws.customer.engagement:connectcases_create_case]{create_case} \tab If you provide a value for PerformedBy\cr
\link[paws.customer.engagement:connectcases_create_case_rule]{create_case_rule} \tab Creates a new case rule\cr
\link[paws.customer.engagement:connectcases_create_domain]{create_domain} \tab Creates a domain, which is a container for all case data, such as cases, fields, templates and layouts\cr
\link[paws.customer.engagement:connectcases_create_field]{create_field} \tab Creates a field in the Cases domain\cr
\link[paws.customer.engagement:connectcases_create_layout]{create_layout} \tab Creates a layout in the Cases domain\cr
\link[paws.customer.engagement:connectcases_create_related_item]{create_related_item} \tab Creates a related item (comments, tasks, and contacts) and associates it with a case\cr
\link[paws.customer.engagement:connectcases_create_template]{create_template} \tab Creates a template in the Cases domain\cr
\link[paws.customer.engagement:connectcases_delete_case_rule]{delete_case_rule} \tab Deletes a case rule\cr
\link[paws.customer.engagement:connectcases_delete_domain]{delete_domain} \tab Deletes a Cases domain\cr
\link[paws.customer.engagement:connectcases_delete_field]{delete_field} \tab Deletes a field from a cases template\cr
\link[paws.customer.engagement:connectcases_delete_layout]{delete_layout} \tab Deletes a layout from a cases template\cr
\link[paws.customer.engagement:connectcases_delete_template]{delete_template} \tab Deletes a cases template\cr
\link[paws.customer.engagement:connectcases_get_case]{get_case} \tab Returns information about a specific case if it exists\cr
\link[paws.customer.engagement:connectcases_get_case_audit_events]{get_case_audit_events} \tab Returns the audit history about a specific case if it exists\cr
\link[paws.customer.engagement:connectcases_get_case_event_configuration]{get_case_event_configuration} \tab Returns the case event publishing configuration\cr
\link[paws.customer.engagement:connectcases_get_domain]{get_domain} \tab Returns information about a specific domain if it exists\cr
\link[paws.customer.engagement:connectcases_get_layout]{get_layout} \tab Returns the details for the requested layout\cr
\link[paws.customer.engagement:connectcases_get_template]{get_template} \tab Returns the details for the requested template\cr
\link[paws.customer.engagement:connectcases_list_case_rules]{list_case_rules} \tab Lists all case rules in a Cases domain\cr
\link[paws.customer.engagement:connectcases_list_cases_for_contact]{list_cases_for_contact} \tab Lists cases for a given contact\cr
\link[paws.customer.engagement:connectcases_list_domains]{list_domains} \tab Lists all cases domains in the Amazon Web Services account\cr
\link[paws.customer.engagement:connectcases_list_field_options]{list_field_options} \tab Lists all of the field options for a field identifier in the domain\cr
\link[paws.customer.engagement:connectcases_list_fields]{list_fields} \tab Lists all fields in a Cases domain\cr
\link[paws.customer.engagement:connectcases_list_layouts]{list_layouts} \tab Lists all layouts in the given cases domain\cr
\link[paws.customer.engagement:connectcases_list_tags_for_resource]{list_tags_for_resource} \tab Lists tags for a resource\cr
\link[paws.customer.engagement:connectcases_list_templates]{list_templates} \tab Lists all of the templates in a Cases domain\cr
\link[paws.customer.engagement:connectcases_put_case_event_configuration]{put_case_event_configuration} \tab Adds case event publishing configuration\cr
\link[paws.customer.engagement:connectcases_search_cases]{search_cases} \tab Searches for cases within their associated Cases domain\cr
\link[paws.customer.engagement:connectcases_search_related_items]{search_related_items} \tab Searches for related items that are associated with a case\cr
\link[paws.customer.engagement:connectcases_tag_resource]{tag_resource} \tab Adds tags to a resource\cr
\link[paws.customer.engagement:connectcases_untag_resource]{untag_resource} \tab Untags a resource\cr
\link[paws.customer.engagement:connectcases_update_case]{update_case} \tab If you provide a value for PerformedBy\cr
\link[paws.customer.engagement:connectcases_update_case_rule]{update_case_rule} \tab Updates a case rule\cr
\link[paws.customer.engagement:connectcases_update_field]{update_field} \tab Updates the properties of an existing field\cr
\link[paws.customer.engagement:connectcases_update_layout]{update_layout} \tab Updates the attributes of an existing layout\cr
\link[paws.customer.engagement:connectcases_update_template]{update_template} \tab Updates the attributes of an existing template
}
}

\examples{
\dontrun{
svc <- connectcases()
svc$batch_get_case_rule(
  Foo = 123
)
}

}
