% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{resiliencehub}
\alias{resiliencehub}
\title{AWS Resilience Hub}
\usage{
resiliencehub(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Resilience Hub helps you proactively prepare and protect your Amazon Web
Services applications from disruptions. It offers continual resiliency
assessment and validation that integrates into your software development
lifecycle. This enables you to uncover resiliency weaknesses, ensure
recovery time objective (RTO) and recovery point objective (RPO) targets
for your applications are met, and resolve issues before they are
released into production.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- resiliencehub(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.management:resiliencehub_accept_resource_grouping_recommendations]{accept_resource_grouping_recommendations} \tab Accepts the resource grouping recommendations suggested by Resilience Hub for your application\cr
\link[paws.management:resiliencehub_add_draft_app_version_resource_mappings]{add_draft_app_version_resource_mappings} \tab Adds the source of resource-maps to the draft version of an application\cr
\link[paws.management:resiliencehub_batch_update_recommendation_status]{batch_update_recommendation_status} \tab Enables you to include or exclude one or more operational recommendations\cr
\link[paws.management:resiliencehub_create_app]{create_app} \tab Creates an Resilience Hub application\cr
\link[paws.management:resiliencehub_create_app_version_app_component]{create_app_version_app_component} \tab Creates a new Application Component in the Resilience Hub application\cr
\link[paws.management:resiliencehub_create_app_version_resource]{create_app_version_resource} \tab Adds a resource to the Resilience Hub application and assigns it to the specified Application Components\cr
\link[paws.management:resiliencehub_create_recommendation_template]{create_recommendation_template} \tab Creates a new recommendation template for the Resilience Hub application\cr
\link[paws.management:resiliencehub_create_resiliency_policy]{create_resiliency_policy} \tab Creates a resiliency policy for an application\cr
\link[paws.management:resiliencehub_delete_app]{delete_app} \tab Deletes an Resilience Hub application\cr
\link[paws.management:resiliencehub_delete_app_assessment]{delete_app_assessment} \tab Deletes an Resilience Hub application assessment\cr
\link[paws.management:resiliencehub_delete_app_input_source]{delete_app_input_source} \tab Deletes the input source and all of its imported resources from the Resilience Hub application\cr
\link[paws.management:resiliencehub_delete_app_version_app_component]{delete_app_version_app_component} \tab Deletes an Application Component from the Resilience Hub application\cr
\link[paws.management:resiliencehub_delete_app_version_resource]{delete_app_version_resource} \tab Deletes a resource from the Resilience Hub application\cr
\link[paws.management:resiliencehub_delete_recommendation_template]{delete_recommendation_template} \tab Deletes a recommendation template\cr
\link[paws.management:resiliencehub_delete_resiliency_policy]{delete_resiliency_policy} \tab Deletes a resiliency policy\cr
\link[paws.management:resiliencehub_describe_app]{describe_app} \tab Describes an Resilience Hub application\cr
\link[paws.management:resiliencehub_describe_app_assessment]{describe_app_assessment} \tab Describes an assessment for an Resilience Hub application\cr
\link[paws.management:resiliencehub_describe_app_version]{describe_app_version} \tab Describes the Resilience Hub application version\cr
\link[paws.management:resiliencehub_describe_app_version_app_component]{describe_app_version_app_component} \tab Describes an Application Component in the Resilience Hub application\cr
\link[paws.management:resiliencehub_describe_app_version_resource]{describe_app_version_resource} \tab Describes a resource of the Resilience Hub application\cr
\link[paws.management:resiliencehub_describe_app_version_resources_resolution_status]{describe_app_version_resources_resolution_status} \tab Returns the resolution status for the specified resolution identifier for an application version\cr
\link[paws.management:resiliencehub_describe_app_version_template]{describe_app_version_template} \tab Describes details about an Resilience Hub application\cr
\link[paws.management:resiliencehub_describe_draft_app_version_resources_import_status]{describe_draft_app_version_resources_import_status} \tab Describes the status of importing resources to an application version\cr
\link[paws.management:resiliencehub_describe_metrics_export]{describe_metrics_export} \tab Describes the metrics of the application configuration being exported\cr
\link[paws.management:resiliencehub_describe_resiliency_policy]{describe_resiliency_policy} \tab Describes a specified resiliency policy for an Resilience Hub application\cr
\link[paws.management:resiliencehub_describe_resource_grouping_recommendation_task]{describe_resource_grouping_recommendation_task} \tab Describes the resource grouping recommendation tasks run by Resilience Hub for your application\cr
\link[paws.management:resiliencehub_import_resources_to_draft_app_version]{import_resources_to_draft_app_version} \tab Imports resources to Resilience Hub application draft version from different input sources\cr
\link[paws.management:resiliencehub_list_alarm_recommendations]{list_alarm_recommendations} \tab Lists the alarm recommendations for an Resilience Hub application\cr
\link[paws.management:resiliencehub_list_app_assessment_compliance_drifts]{list_app_assessment_compliance_drifts} \tab List of compliance drifts that were detected while running an assessment\cr
\link[paws.management:resiliencehub_list_app_assessment_resource_drifts]{list_app_assessment_resource_drifts} \tab List of resource drifts that were detected while running an assessment\cr
\link[paws.management:resiliencehub_list_app_assessments]{list_app_assessments} \tab Lists the assessments for an Resilience Hub application\cr
\link[paws.management:resiliencehub_list_app_component_compliances]{list_app_component_compliances} \tab Lists the compliances for an Resilience Hub Application Component\cr
\link[paws.management:resiliencehub_list_app_component_recommendations]{list_app_component_recommendations} \tab Lists the recommendations for an Resilience Hub Application Component\cr
\link[paws.management:resiliencehub_list_app_input_sources]{list_app_input_sources} \tab Lists all the input sources of the Resilience Hub application\cr
\link[paws.management:resiliencehub_list_apps]{list_apps} \tab Lists your Resilience Hub applications\cr
\link[paws.management:resiliencehub_list_app_version_app_components]{list_app_version_app_components} \tab Lists all the Application Components in the Resilience Hub application\cr
\link[paws.management:resiliencehub_list_app_version_resource_mappings]{list_app_version_resource_mappings} \tab Lists how the resources in an application version are mapped/sourced from\cr
\link[paws.management:resiliencehub_list_app_version_resources]{list_app_version_resources} \tab Lists all the resources in an Resilience Hub application\cr
\link[paws.management:resiliencehub_list_app_versions]{list_app_versions} \tab Lists the different versions for the Resilience Hub applications\cr
\link[paws.management:resiliencehub_list_metrics]{list_metrics} \tab Lists the metrics that can be exported\cr
\link[paws.management:resiliencehub_list_recommendation_templates]{list_recommendation_templates} \tab Lists the recommendation templates for the Resilience Hub applications\cr
\link[paws.management:resiliencehub_list_resiliency_policies]{list_resiliency_policies} \tab Lists the resiliency policies for the Resilience Hub applications\cr
\link[paws.management:resiliencehub_list_resource_grouping_recommendations]{list_resource_grouping_recommendations} \tab Lists the resource grouping recommendations suggested by Resilience Hub for your application\cr
\link[paws.management:resiliencehub_list_sop_recommendations]{list_sop_recommendations} \tab Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications\cr
\link[paws.management:resiliencehub_list_suggested_resiliency_policies]{list_suggested_resiliency_policies} \tab Lists the suggested resiliency policies for the Resilience Hub applications\cr
\link[paws.management:resiliencehub_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags for your resources in your Resilience Hub applications\cr
\link[paws.management:resiliencehub_list_test_recommendations]{list_test_recommendations} \tab Lists the test recommendations for the Resilience Hub application\cr
\link[paws.management:resiliencehub_list_unsupported_app_version_resources]{list_unsupported_app_version_resources} \tab Lists the resources that are not currently supported in Resilience Hub\cr
\link[paws.management:resiliencehub_publish_app_version]{publish_app_version} \tab Publishes a new version of a specific Resilience Hub application\cr
\link[paws.management:resiliencehub_put_draft_app_version_template]{put_draft_app_version_template} \tab Adds or updates the app template for an Resilience Hub application draft version\cr
\link[paws.management:resiliencehub_reject_resource_grouping_recommendations]{reject_resource_grouping_recommendations} \tab Rejects resource grouping recommendations\cr
\link[paws.management:resiliencehub_remove_draft_app_version_resource_mappings]{remove_draft_app_version_resource_mappings} \tab Removes resource mappings from a draft application version\cr
\link[paws.management:resiliencehub_resolve_app_version_resources]{resolve_app_version_resources} \tab Resolves the resources for an application version\cr
\link[paws.management:resiliencehub_start_app_assessment]{start_app_assessment} \tab Creates a new application assessment for an application\cr
\link[paws.management:resiliencehub_start_metrics_export]{start_metrics_export} \tab Initiates the export task of metrics\cr
\link[paws.management:resiliencehub_start_resource_grouping_recommendation_task]{start_resource_grouping_recommendation_task} \tab Starts grouping recommendation task\cr
\link[paws.management:resiliencehub_tag_resource]{tag_resource} \tab Applies one or more tags to a resource\cr
\link[paws.management:resiliencehub_untag_resource]{untag_resource} \tab Removes one or more tags from a resource\cr
\link[paws.management:resiliencehub_update_app]{update_app} \tab Updates an application\cr
\link[paws.management:resiliencehub_update_app_version]{update_app_version} \tab Updates the Resilience Hub application version\cr
\link[paws.management:resiliencehub_update_app_version_app_component]{update_app_version_app_component} \tab Updates an existing Application Component in the Resilience Hub application\cr
\link[paws.management:resiliencehub_update_app_version_resource]{update_app_version_resource} \tab Updates the resource details in the Resilience Hub application\cr
\link[paws.management:resiliencehub_update_resiliency_policy]{update_resiliency_policy} \tab Updates a resiliency policy
}
}

\examples{
\dontrun{
svc <- resiliencehub()
svc$accept_resource_grouping_recommendations(
  Foo = 123
)
}

}
