% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lattice.pbo.R
\name{xyplot.pbo}
\alias{xyplot.pbo}
\title{PBO xy-plots}
\usage{
\method{xyplot}{pbo}(
  x,
  data = NULL,
  plotType = "cscv",
  show_eqn = TRUE,
  show_threshold = TRUE,
  show_config = TRUE,
  show_rug = TRUE,
  show_prob = TRUE,
  show_grid = TRUE,
  increment = 0.01,
  osr_threshold = 0,
  sel_threshold = 0,
  xlab,
  ylab,
  main,
  lwd = 1,
  ylab_left,
  ylab_right,
  col_bar,
  col_line,
  col_sd1 = "#3366cc",
  col_sd2 = "#339999",
  lty_sd = c(1, 2, 4),
  ...
)
}
\arguments{
\item{x}{a \code{pbo} object as returned by \code{\link{pbo}}.}

\item{data}{should not be used}

\item{plotType}{one of \code{cscv}, \code{degradation}, \code{dominance},
\code{pairs}, \code{ranks} or \code{selection}.}

\item{show_eqn}{whether to show the line equation annotation, default TRUE}

\item{show_threshold}{whether to show the probability of loss annotation,
default TRUE}

\item{show_config}{whether to show the study dimension annotations,
default TRUE}

\item{show_rug}{whether to show scatter rugs near the axes,
default TRUE}

\item{show_prob}{whether to show the probability value in dominance plot,
default TRUE}

\item{show_grid}{whether to show the panel grid,
default TRUE}

\item{increment}{stochastic dominance distribution generator increment,
e.g. 0.1 steps}

\item{osr_threshold}{out-of-sample rank threshold for filtering, default 0}

\item{sel_threshold}{selection frequency threshold for filtering, default 0}

\item{xlab}{x-axis label, default computed if not provided}

\item{ylab}{y-axis label, default computed if not provided}

\item{main}{plot title, default computed if not provided}

\item{lwd}{line width, default 1, passed to panels and legends}

\item{ylab_left}{dominance plot left-hand axis label}

\item{ylab_right}{dominance plot right-hand axis label}

\item{col_bar}{histogram bar fill color}

\item{col_line}{density plot line color}

\item{col_sd1}{color of two first-order stochastic dominance lines}

\item{col_sd2}{color of the single second-order stochastic dominance line}

\item{lty_sd}{line type array for stochastic dominance plot,
e.g. c(2,3,5)}

\item{...}{other parameters passed to \code{\link[lattice]{xyplot}}
or its panels}
}
\description{
Draws an annotated plot of performance degradation and
probability of loss.
}
\details{
Provides several variations of xy-plots suitable for presentation
of PBO analysis results.  Use the \code{plotType} argument to indicate
which variation or result to plot:
\itemize{
\item The \code{cscv} type shows in-sample
and out-of-sample results by CSCV iteration case (default).
\item The \code{degradation} type shows the performance degradation regression
fit results and the probability of loss.
\item The \code{dominance} type shows the results of the first-order and
second-order stochastic dominance analysis using two axes.
\item The \code{pairs} type shows the in-sample and out-of-sample
case selections.
\item The \code{ranks} type shows the sorted performance ranks results.
\item The \code{selection} type shows the case selection frequencies.
}
}
\seealso{
pbo, histogram.pbo, xyplot.pbo
}
\keyword{CSCV}
\keyword{PBO}
