% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{Idom.setCSstd.tri}
\alias{Idom.setCSstd.tri}
\title{The indicator for the set of points \code{S} being a dominating set or not for Central Similarity Proximity
Catch Digraphs (CS-PCDs) - standard equilateral triangle case}
\usage{
Idom.setCSstd.tri(S, Xp, t, M = c(1, 1, 1))
}
\arguments{
\item{S}{A set of 2D points which is to be tested for being a dominating set for the CS-PCDs.}

\item{Xp}{A set of 2D points which constitute the vertices of the CS-PCD.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region in the
standard equilateral triangle \eqn{T_e=T((0,0),(1,0),(1/2,\sqrt{3}/2))}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the standard equilateral triangle \eqn{T_e}; default is \eqn{M=(1,1,1)} i.e.
the center of mass of \eqn{T_e}.}
}
\value{
\eqn{I(}\code{S} a dominating set of the CS-PCD\eqn{)}, that is, returns 1 if \code{S} is a dominating set of CS-PCD,
returns 0 otherwise, where CS proximity region is constructed in the standard equilateral triangle \eqn{T_e}
}
\description{
Returns \eqn{I(}\code{S} a dominating set of the CS-PCD\eqn{)} where the vertices of the CS-PCD are the data set \code{Xp}), that is,
returns 1 if \code{S} is a dominating set of CS-PCD, returns 0 otherwise.

CS proximity region is constructed
with respect to the standard equilateral triangle \eqn{T_e=T(A,B,C)=T((0,0),(1,0),(1/2,\sqrt{3}/2))} with
expansion parameter \eqn{t>0} and edge regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \eqn{T_e} (which is equivalent to the circumcenter of \eqn{T_e}).

Edges of \eqn{T_e}, \eqn{AB}, \eqn{BC}, \eqn{AC}, are also labeled as 3, 1, and 2, respectively.

See also (\insertCite{ceyhan:mcap2012;textual}{pcds}).
}
\examples{
\donttest{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-runif.std.tri(n)$gen.points

M<-as.numeric(runif.std.tri(1)$g)  #try also M<-c(.6,.2)

t<-.5

S<-rbind(Xp[1,],Xp[2,])
Idom.setCSstd.tri(S,Xp,t,M)

S<-rbind(Xp[1,],Xp[2,],Xp[3,],Xp[5,])
Idom.setCSstd.tri(S,Xp,t,M)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{Idom.setCStri}} and \code{\link{Idom.setPEstd.tri}}
}
\author{
Elvan Ceyhan
}
