% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim2D.R
\name{inci.matCSstd.tri}
\alias{inci.matCSstd.tri}
\title{Incidence matrix for Central Similarity Proximity Catch Digraphs (CS-PCDs) - standard
equilateral triangle case}
\usage{
inci.matCSstd.tri(Xp, t, M = c(1, 1, 1))
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the CS-PCD.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates.
which serves as a center in the interior of the standard equilateral triangle \eqn{T_e}; default is \eqn{M=(1,1,1)} i.e.
the center of mass of \eqn{T_e}.}
}
\value{
Incidence matrix for the CS-PCD with vertices being 2D data set, \code{Xp} and CS proximity
regions are defined in the standard equilateral triangle \eqn{T_e} with \code{M}-edge regions.
}
\description{
Returns the incidence matrix for the CS-PCD whose vertices are the given 2D numerical data set, \code{Xp},
in the standard equilateral triangle \eqn{T_e=T(v=1,v=2,v=3)=T((0,0),(1,0),(1/2,\sqrt{3}/2))}.

CS proximity region is defined with respect to the standard equilateral triangle
\eqn{T_e=T(v=1,v=2,v=3)=T((0,0),(1,0),(1/2,\sqrt{3}/2))} and edge regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e., the center of mass of \eqn{T_e}.
Loops are allowed, so the diagonal entries are all equal to 1.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}).
}
\examples{
\donttest{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C);
n<-10

set.seed(1)
Xp<-runif.std.tri(n)$gen.points

M<-as.numeric(runif.std.tri(1)$g)  #try also M<-c(.6,.2)

inc.mat<-inci.matCSstd.tri(Xp,t=1.25,M)
inc.mat
sum(inc.mat)-n
num.arcsCSstd.tri(Xp,t=1.25)

dom.num.greedy(inc.mat) #try also dom.num.exact(inc.mat)  #might take a long time for large n
Idom.num.up.bnd(inc.mat,1)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{inci.matCStri}}, \code{\link{inci.matCS}} and \code{\link{inci.matPEstd.tri}}
}
\author{
Elvan Ceyhan
}
