% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{rel.vert.triCM}
\alias{rel.vert.triCM}
\title{The index of the \eqn{CM}-vertex region in a triangle that contains a given point}
\usage{
rel.vert.triCM(p, tri)
}
\arguments{
\item{p}{A 2D point for which \eqn{CM}-vertex region it resides in
is to be determined in the triangle \code{tri}.}

\item{tri}{A \eqn{3 \times 2} matrix with each row
representing a vertex of the triangle.}
}
\value{
A \code{list} with two elements
\item{rv}{Index of the \eqn{CM}-vertex region that contains point,
\code{p} in the triangle \code{tri}.}
\item{tri}{The vertices of the triangle,
where row number corresponds to the vertex index in \code{rv}.}
}
\description{
Returns the index of the vertex
whose region contains point \code{p} in
the triangle \code{tri}\eqn{=(y_1,y_2,y_3)}
with vertex regions are constructed with center of mass \eqn{CM=(y_1+y_2+y_3)/3}
(see the plots in the example for illustrations).

The vertices of triangle, \code{tri},
are labeled as \eqn{1,2,3}
according to the row number the vertex is recorded in \code{tri}.
If the point, \code{p}, is not inside \code{tri},
then the function yields \code{NA} as output.
The corresponding vertex region is the polygon with the vertex, \eqn{CM},
and midpoints of the edges adjacent to the vertex.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds})
}
\examples{
\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.6,2);
Tr<-rbind(A,B,C);
P<-c(1.4,1.2)
rel.vert.triCM(P,Tr)

n<-20  #try also n<-40
Xp<-runif.tri(n,Tr)$g

Rv<-vector()
for (i in 1:n)
  Rv<-c(Rv,rel.vert.triCM(Xp[i,],Tr)$rv)
Rv

CM<-(A+B+C)/3
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)

Xlim<-range(Tr[,1],Xp[,1])
Ylim<-range(Tr[,2],Xp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tr,xlab="",ylab="",axes=TRUE,pch=".",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
points(Xp,pch=".")
L<-Ds; R<-matrix(rep(CM,3),ncol=2,byrow=TRUE)
segments(L[,1], L[,2], R[,1], R[,2], lty = 2)
text(Xp,labels=factor(Rv))

txt<-rbind(Tr,CM,D1,D2,D3)
xc<-txt[,1]+c(-.02,.02,.02,-.02,.02,-.01,-.01)
yc<-txt[,2]+c(-.02,-.04,.06,-.02,.02,.06,-.06)
txt.str<-c("rv=1","rv=2","rv=3","CM","D1","D2","D3")
text(xc,yc,txt.str)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rel.vert.tri}}, \code{\link{rel.vert.triCC}}, \code{\link{rel.vert.basic.triCM}},
\code{\link{rel.vert.basic.triCC}}, \code{\link{rel.vert.basic.tri}}, and \code{\link{rel.vert.std.triCM}}
}
\author{
Elvan Ceyhan
}
