% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logical_estimation.R
\name{model_and}
\alias{model_and}
\title{Approximate a linear model for a series of logical AND statements using PCSS}
\usage{
model_and(formula, n, means, covs, predictors, ...)
}
\arguments{
\item{formula}{an object of class \code{formula} whose dependent variable is
a combination of variables and logical \code{&} operators. All model terms
must be accounted for in \code{means} and \code{covs}.}

\item{n}{sample size.}

\item{means}{named vector of predictor and response means.}

\item{covs}{named matrix of the covariance of all model predictors and the
responses.}

\item{predictors}{named list of objects of class \code{predictor}.}

\item{...}{additional arguments}
}
\value{
an object of class \code{"pcsslm"}.

  An object of class \code{"pcsslm"} is a list containing at least the 
  following components:
    \item{call}{the matched call}
    \item{terms}{the \code{terms} object used}
    \item{coefficients}{a \eqn{p x 4} matrix with columns for the 
      estimated coefficient, its standard error, t-statistic and
      corresponding (two-sided) p-value.}
    \item{sigma}{the square root of the estimated variance of the random
      error.}
    \item{df}{degrees of freedom, a 3-vector \eqn{p, n-p, p*}, the
      first being the number of non-aliased coefficients, the last being
      the total number of coefficients.}
    \item{fstatistic}{a 3-vector with the value of the F-statistic with its
      numerator and denominator degrees of freedom.}
    \item{r.squared}{\eqn{R^2}, the 'fraction of variance explained by the 
      model'.}
    \item{adj.r.squared}{the above \eqn{R^2} statistic \emph{'adjusted'},
      penalizing for higher \eqn{p}.}
    \item{cov.unscaled}{a \eqn{p x p} matrix of (unscaled) covariances of the
      \eqn{coef[j], j=1,...p}.}
    \item{Sum Sq}{a 3-vector with the model's Sum of Squares Regression 
      (SSR), Sum of Squares Error (SSE), and Sum of Squares Total (SST).}
}
\description{
\code{model_and} approximates the linear model for the conjunction
  of m phenotypes as a function of a set of predictors.
}
\examples{
ex_data <- pcsstools_example[c("g1", "x1", "y4", "y5")]
head(ex_data)
means <- colMeans(ex_data)
covs <- cov(ex_data)
n <- nrow(ex_data)
predictors <- list(
  g1 = new_predictor_snp(maf = mean(ex_data$g1) / 2),
  x1 = new_predictor_normal(mean = mean(ex_data$x1), sd = sd(ex_data$x1))
)

model_and(
  y4 & y5 ~ g1 + x1,
  means = means, covs = covs, n = n, predictors = predictors
)
summary(lm(y4 & y5 ~ g1 + x1, data = ex_data))
}
\references{
{

  \insertRef{wolf_using_2021}{pcsstools}
  
}
}
