% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{ggmosaic}
\alias{ggmosaic}
\title{ggmosaic for mosaic plot}
\usage{
ggmosaic(
  tab,
  rect_params = list(),
  rect_space = 0,
  show_number = c("number", "percentage", "none")[1],
  number_params = list(),
  x_label = c("top", "bottom", "none")[1],
  y_label = c("right", "left", "none")[1],
  label_params = list(),
  chisq_test = TRUE
)
}
\arguments{
\item{tab}{your dataframe, must have 3 columns, the third column must be numeric}

\item{rect_params}{parameters parse to \code{\link[ggplot2]{geom_rect}}}

\item{rect_space}{rect_space, defalut 0.}

\item{show_number}{show "number" or "percentage" or "none"}

\item{number_params}{parameters parse to \code{\link[ggplot2]{geom_text}}}

\item{x_label}{show x label on "top" or "bottom" or "none"}

\item{y_label}{show y label on "right" or "left" or "none"}

\item{label_params}{parameters parse to \code{\link[ggplot2]{geom_text}}}

\item{chisq_test}{whether show chisq test}
}
\value{
a ggplot
}
\description{
ggmosaic for mosaic plot
}
\examples{
data(mtcars)
tab <- dplyr::count(mtcars, gear, cyl)
ggmosaic(tab,
  show_number = "number", x_label = "top",
  y_label = "right", chisq_test = TRUE
)
}
