% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmPlot.R
\name{brmPlot}
\alias{brmPlot}
\title{Function to visualize brms models similar to those made using growthSS outputs.}
\usage{
brmPlot(
  fit,
  form,
  df = NULL,
  groups = NULL,
  timeRange = NULL,
  facetGroups = TRUE,
  hierarchy_value = NULL,
  vir_option = "plasma"
)
}
\arguments{
\item{fit}{A brmsfit object, similar to those fit with \code{\link{growthSS}} outputs.}

\item{form}{A formula similar to that in \code{growthSS} inputs specifying the outcome,
predictor, and grouping structure of the data as \code{outcome ~ predictor|individual/group}.}

\item{df}{An optional dataframe to use in plotting observed growth curves on top of the model.}

\item{groups}{An optional set of groups to keep in the plot.
Defaults to NULL in which case all groups in the model are plotted.}

\item{timeRange}{An optional range of times to use. This can be used to view predictions for
future data if the available data has not reached some point (such as asymptotic size),
although prediction using splines outside of the observed range is not necessarily reliable.}

\item{facetGroups}{logical, should groups be separated in facets? Defaults to TRUE.}

\item{hierarchy_value}{If a hierarchical model is being plotted, what value should the
hierarchical predictor be? If left NULL (the default) the mean value is used. If this is >1L
then the x axis will use the hierarchical variable from the model at the mean of the timeRange
(mean of x values in the model if timeRange is not specified).}

\item{vir_option}{Viridis color scale to use for plotting credible intervals. Defaults to "plasma".}
}
\value{
Returns a ggplot showing a brms model's credible
intervals and optionally the individual growth lines.
}
\description{
Models fit using \link{growthSS} inputs by \link{fitGrowth} (and similar models made through other
means) can be visualized easily using this function. This will generally be called by
\code{growthPlot}.
}
\examples{
\donttest{
simdf <- growthSim(
  "logistic",
  n = 20, t = 25,
  params = list("A" = c(200, 160), "B" = c(13, 11), "C" = c(3, 3.5))
)
ss <- growthSS(
  model = "logistic", form = y ~ time | id / group, sigma = "spline",
  list("A" = 130, "B" = 10, "C" = 3),
  df = simdf, type = "brms"
)
fit <- fitGrowth(ss, backend = "cmdstanr", iter = 500, chains = 1, cores = 1)
growthPlot(fit = fit, form = y ~ time | group, groups = "a", df = ss$df)
}

}
\keyword{brms}
\keyword{growth-curve}
