% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_remove_NA_series_above_k.R
\name{do_remove_NA_series_above_k}
\alias{do_remove_NA_series_above_k}
\title{do_remove_NA_series_above_k}
\usage{
do_remove_NA_series_above_k(x, y, k, x_values = NULL)
}
\arguments{
\item{x}{factor vector to indicate conditions or phases (e.g., "A" and "B")}

\item{y}{numeric vector with the observed y-values}

\item{k}{maximum allowed number of NA's}

\item{x_values}{numerical vector with distance (time markers) between observations}
}
\value{
List with the modified x, y, x_values:
  x = factor vector with conditions (e.g., "A" and "B").
  y = vector with observed values.
  x_values = vector with distance (time markers) between observations x,y.
}
\description{
Remove series of more than k succeeding NA's in x, y, and x_values.
This function is recommended before performing a permutation distancing test.
}
\examples{
pdt::do_remove_NA_series_above_k(as.factor(c("A","A","A","B","B","B")),
  c(1.1,NA,NA,7.1,8.3,9.8), 1, c(1,2,4,5,6,8))

}
