% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-gml.R
\docType{data}
\name{gml_mid_dirleaderdisps}
\alias{gml_mid_dirleaderdisps}
\title{Directed Leader-Dyadic Dispute-Year Data (GML, v. 2.2.1, Archigos v. 4.1)}
\format{
A data frame with 11,686 observations on the following 16 variables.
\describe{
\item{\code{dispnum}}{a numeric vector for the dispute number}
\item{\code{ccode1}}{a numeric vector for the focal state in the dyad}
\item{\code{ccode2}}{a numeric vector for the target state in the dyad}
\item{\code{obsid1}}{a character vector for the leader of the focal state in the dyad, if available}
\item{\code{obsid2}}{a character vector for the leader of the target state in the dyad, if available}
\item{\code{year}}{a numeric vector for the dispute-year}
\item{\code{gmlmidongoing}}{a numeric vector for whether there was a dispute ongoing in that year}
\item{\code{gmlmidonset}}{a numeric vector for whether it was the onset of a new dispute (or new participant-entry into a recurring dispute)}
\item{\code{sidea1}}{is \code{ccode1} on side A of the dispute?}
\item{\code{sidea2}}{is \code{ccode2} on side A of the dispute?}
\item{\code{orig1}}{is \code{ccode1} an originator of the dispute?}
\item{\code{orig2}}{is \code{ccode2} an originator of the dispute?}
\item{\code{obsid_start1}}{the ID of the leader at the dispute onset for \code{ccode1}}
\item{\code{obsid_start2}}{the ID of the leader at the dispute onset for \code{ccode2}}
\item{\code{obsid_end1}}{the ID of the leader at the dispute conclusion for \code{ccode1}}
\item{\code{obsid_end2}}{the ID of the leader at the dispute conclusion for \code{ccode2}}
}
}
\usage{
gml_mid_dirleaderdisps
}
\description{
These are directed leader-dyadic dispute year data derived from the
Gibler-Miller-Little (GML) Militarized Interstate Dispute (MID) project. Data
are from version 2.2.1 (GML-MID) and version 4.1 (Archigos). The data are all
relevant dyadic leader pairings in conflict, allowing users to employ their
own case exclusion rules to the data as they see fit.
}
\details{
The process of creating these is described at one of the references below.
Importantly, these data are somewhat "naive." That is: they won't tell you,
for example, that Brazil and Japan never directly fought each other during
World War II. Instead, it will tell you that there were two years of overlap
for the two on different sides of the conflict and that the highest action
for both was a war. The data are thus similar to what the \code{EUGene}
program would create for users back in the day. Use these data with that
limitation in mind.

Be mindful that Archigos' leader data are nominally denominated in
Gleditsch-Ward states, which are standardized to Correlates of War state
system membership as well as the data can allow. There will be some missing
leaders after 1870 because Archigos is ultimately its own system.
}
\references{
Miller, Steven V. 2021. "How to (Meticulously) Convert Participant-Level
Dispute Data to Dyadic Dispute-Year Data in R."
URL: \url{https://svmiller.com/blog/2021/05/convert-cow-mid-data-to-dispute-year/}

Gibler, Douglas M., Steven V. Miller, and Erin K. Little. 2016. “An Analysis
of the Militarized Interstate Dispute (MID) Dataset, 1816-2001.”
\emph{International Studies Quarterly} 60(4): 719-730.

Goemans, Henk E., Kristian Skrede Gleditsch, and Giacomo Chiozza. 2009.
"Introducing Archigos: A Dataset of Political Leaders" \emph{Journal of Peace
Research} 46(2): 269--83.
}
\keyword{datasets}
