% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skewness.R
\name{skewness}
\alias{skewness}
\title{Moment coefficient of skewness}
\usage{
skewness(x)
}
\arguments{
\item{x}{Numeric vector, the values of the variable of interest.}
}
\value{
A numerical value: the moment coefficient of skewness of \code{x}.
}
\description{
Compute the moment coefficient of skewness of a continuous, possibly non-normal variable.
}
\examples{
x <- rlnorm(10)
skw <- skewness(x)
}
\references{
B. S. Everitt, \emph{The Cambridge Dictionary of Statistics}, 3rd ed. Cambridge: Cambridge University
Press, 2006, p. 432.

D. N. Joanes and C. A. Gill, Comparing measures of sample skewness and kurtosis, \emph{J Royal
Statistical Soc D}, vol. 47, no. 1, pp. 183–189, Mar. 1998, doi: 10.1111/1467-9884.00122.

H. Cramér, \emph{Mathematical Methods of Statistics}. Princeton: Princeton University Press, 1946,
p. 575.
}
\author{
Alessandro Samuel-Rosa \email{alessandrosamuelrosa@gmail.com}
}
