% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iceberg.R
\name{iceberg}
\alias{iceberg}
\title{Iceberg Lasso Implementation (in development)}
\usage{
iceberg(data, dep, indep = NULL, selectobs = NULL, ...)
}
\arguments{
\item{data}{A data frame containing all relevant variables.}

\item{dep}{A string with the names of the independent variables or their column numbers.}

\item{indep}{A vector with the names or column numbers of the regressors. If left unspecified,
all remaining variables (excluding fixed effects) are included in the regressor matrix.}

\item{selectobs}{Optional. A vector indicating which observations to use (either a logical vector
or a numeric vector with row numbers, as usual when subsetting in R).}

\item{...}{Further arguments, including:
\itemize{
\item \code{tol}: Tolerance parameter for convergence of the IRLS algorithm.
\item \code{glmnettol}: Tolerance parameter to be passed on to \code{glmnet::glmnet}.
\item \code{penweights}: Optional: a vector of coefficient-specific penalties to use in plugin lasso.
\item \code{colcheck}: Logical. If \code{TRUE}, checks for perfect multicollinearity in \code{x}.
\item \code{K}: Maximum number of iterations.
\item \code{verbose}: Logical. If \code{TRUE}, prints information to the screen while evaluating.
\item \code{lambda}: Penalty parameter (a number).
\item \code{icepost}: Logical. If \code{TRUE}, it carries out a post-lasso estimation with just the
selected variables and reports the coefficients from this regression.
}}
}
\value{
A matrix with coefficient estimates for all dependent variables.
}
\description{
A function performs standard plugin lasso PPML estimation (without fixed effects) for several
dependent variables in a single step. This is still IN DEVELOPMENT: at the current stage, only
coefficient estimates are are provided and there is no support for clustered errors.
}
\details{
This functions enables users to implement the "iceberg" step in the two-step procedure described in
Breinlich, Corradi, Rocha, Ruta, Santos Silva and Zylkin (2020). To do this after using the plugin
method in \code{mlfitppml}, just select all the variables with non-zero coefficients in
\code{dep} and the remaining regressors in \code{indep}. The function will then perform separate
lasso estimation on each of the selected dependent variables and report the coefficients.
}
\section{References}{

Breinlich, H., Corradi, V., Rocha, N., Ruta, M., Santos Silva, J.M.C. and T. Zylkin (2021).
"Machine Learning in International Trade Research: Evaluating the Impact of Trade Agreements",
Policy Research Working Paper; No. 9629. World Bank, Washington, DC.

Correia, S., P. Guimaraes and T. Zylkin (2020). "Fast Poisson estimation with high dimensional
fixed effects", \emph{STATA Journal}, 20, 90-115.

Gaure, S (2013). "OLS with multiple high dimensional category variables",
\emph{Computational Statistics & Data Analysis}, 66, 8-18.

Friedman, J., T. Hastie, and R. Tibshirani (2010). "Regularization paths for generalized linear
models via coordinate descent", \emph{Journal of Statistical Software}, 33, 1-22.

Belloni, A., V. Chernozhukov, C. Hansen and D. Kozbur (2016). "Inference in high dimensional panel
models with an application to gun control", \emph{Journal of Business & Economic Statistics}, 34, 590-605.
}

\examples{
\donttest{iceberg_results <- iceberg(data = trade[, -(1:6)],
                                    dep = c("ad_prov_14", "cp_prov_23", "tbt_prov_07",
                                            "tbt_prov_33", "tf_prov_41", "tf_prov_45"),
                                    selectobs = (trade$time == "2016"))}

}
