% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_helpers.R
\name{add_ui_body}
\alias{add_ui_body}
\title{Add UI Elements to the Body area}
\usage{
add_ui_body(elementlist = NULL, append = FALSE)
}
\arguments{
\item{elementlist}{list of UI elements to add to the body}

\item{append}{whether to append the \code{elementlist} to the currently
registered elements or replace the currently registered elements completely}
}
\description{
This function registers UI elements to the body of the application (the
right side).  Items are added in the order given.
}
\section{Shiny Usage}{

Call this function after creating elements in \code{program/ui_body.R} to
register them to the application framework and show them on the body area
of the dashboard application
}

\examples{
require(shiny)

body1 <- htmlOutput("example1")
body2 <- actionButton("exButton", label = "Example")

add_ui_body(list(body1, body2))

}
\seealso{
\link[periscope]{add_ui_sidebar_basic}

\link[periscope]{add_ui_sidebar_advanced}
}
