% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augmentation_functions.R
\name{HDtweedie_kfold_aug}
\alias{HDtweedie_kfold_aug}
\title{Fit a penalized gamma augmentation model via cross fitting}
\usage{
HDtweedie_kfold_aug(
  x,
  y,
  trt,
  wts = NULL,
  K = 10,
  p = 1.5,
  interactions = FALSE
)
}
\arguments{
\item{x}{an n x p matrix of covariates for the zero part data, where each row is an observation
and each column is a predictor. MUST be ordered such that the first n_s rows align with the
observations in x_s and s}

\item{y}{a length n vector of responses taking positive values}

\item{trt}{a length n vector of treatment variables with 1 indicating treatment and -1 indicating control}

\item{wts}{a length n vector of sample weights}

\item{K}{number of folds for cross fitting}

\item{p}{tweedie mixing parameter. See \code{\link[HDtweedie]{HDtweedie}} for details}

\item{interactions}{boolean variable of whether or not to fit model with interactions. For predictions,
interactions will be integrated out}
}
\description{
Fits a penalized gamma augmentation model via cross fitting and
returns vector of length n of out of sample predictions on the link scale from cross fitting
}
